package ipsk.webapps.db.speech.ws;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import ipsk.db.speech.Account;
import ipsk.webapps.EntityManagerFactoryInitializer;

@Path("/account")
public class AccountResource extends WikispeechBasicResource<Account>{

	
	
	public AccountResource() {
		super(Account.class);
	}

	
	@GET
	@Produces({MediaType.APPLICATION_JSON,MediaType.APPLICATION_XML})
	@Path("/{login}")
	public Response getAccount(@PathParam("login") String login,@QueryParam("_self") boolean self,@Context HttpServletRequest req){
		EntityManager em=EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		
		try{	
			Account loggedAcc=getAccountByRequest(req, em);
			if(loggedAcc!=null){
				
				if(login==null || loggedAcc.getLogin().equals(login)){
					return Response.ok(loggedAcc).build();
				}
			}
			return Response.status(Status.FORBIDDEN).build();
			
		}finally{
			em.close();
		}
	}
	
}
