package ipsk.webapps.db.speech.ws;

import java.io.IOException;
import java.util.Date;

import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

@Provider
@Priority(1)
public class ClientAbortExceptionWriterInterceptor implements WriterInterceptor {

	public ClientAbortExceptionWriterInterceptor() {
		super();
	}

	@Override
	public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
		//System.out.println(getClass().getName()+"aroundWriteTo");
		try {
			context.proceed();
		}catch(IOException| WebApplicationException wt) {
			//System.out.println(getClass().getName()+"aroundWriteTo exception: "+wt);
			Throwable wtc=wt;
			String sClsNm;
			boolean isClientAbort=false;
			do {
				sClsNm=wtc.getClass().getSimpleName();
				if("ClientAbortException".equalsIgnoreCase(sClsNm)) {
					isClientAbort=true;
					break;
				}
				wtc=wtc.getCause();
			}while(wtc !=null);
			if(isClientAbort) {
				//System.out.println("Warning: WikiSpeech: "+new Date()+": Catched ClientAbortException.");
				// Simplify exception
				IOException caIoe= new IOException("WikiSpeech: Warning: Client abort.");
				caIoe.setStackTrace(new StackTraceElement[] {});
				throw caIoe;
			}else {
				throw wt;
			}
		}
	}

}
