<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" scope="page"/>

<html>
<head>
<script src="<c:url value="/lib/script/ips_lib.js"/>" type="text/javascript"></script>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="project.emu.export"/></title>
</head>

<BODY  onload="ips_startUpdate()">
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="project.export.emu"/></h2>		 
<p><b>Export WikiSpeech project data as emuDB for the <a href="https://ips-lmu.github.io/The-EMU-SDMS-Manual/" target="_blank">EMU Speech Database Management System (EMU-SDMS)</a></b></p>
<p>Creates a database configuration template and JSON annotation file templates.</p>
<p>For audio recordings with two (stereo) or more channels only the first channel is exported!</p>
<h>Annotation levels</h4>
<p>Two emuDB annotation levels are created:</p>
<ul>
	<li><b>Level 'PRT' with type 'ITEM'</b>: Will be annotated with the description of the SpeechRecorder prompt. If the the prompt is plain text the text will be used, formatted text prompts will be converted to plain text. Multimedia file prompts (images,etc.) are annotated with the name of the file.</li>
	<li><b>Level 'TPL' with type 'ITEM'</b>: The annotation template given in the recording script (XML attribute 'annotationTemplate' in element 'mediaitem') will be used for the annotation.</li> 
</ul>
<p>Press '<fmt:message key="start"/>' to build the ZIP archive with the emuDB on the server. When the archive is ready the 'ZIP Download' button will be enabled. Press this button to download the ZIP archive file to your desktop.</p>
<p>Unpack the ZIP archive on your desktop and load the emuDB with the 'load_emuDB()' function of the <a href="https://cran.r-project.org/package=emuR" target="_blank">'emuR' R package</a>.</p>
<jsp:useBean id="projectEmuExportCtrl" scope="session" type="ipsk.webapps.db.speech.ProjectEmuExportController"  />
<jsp:setProperty name="projectEmuExportCtrl" property="ajaxPageContext" value="${pageContext}"/>
<c:if test="${projectEmuExportCtrl.busy == true}">
<c:if test="${projectEmuExportCtrl.projectName != param['name']}">
<p><span style="color:red">Cannot export Project <c:out value="${param['name']}"/>! Export of project <c:out value="${projectEmuExportCtrl.projectName}"/> is currently in progress! Please wait until current export is finished or cancel current export.</span></p>
</c:if>
</c:if>
<p><b><fmt:message key="project"/>: <c:out value="${projectEmuExportCtrl.projectName}"/></b></p>
<p><fmt:message key="status"/>: <span id="status"><c:out value="${projectEmuExportCtrl.statusMessage}"/></span></p>

<form action="<c:url value="/prjdb/project/ProjectEmuExport"/>">

<input type="hidden" name="name" value="${projectEmuExportCtrl.projectName}">
<input id="actionButton" type="submit" name="_${projectEmuExportCtrl.command}" value="<fmt:message key="${projectEmuExportCtrl.command}"/>"/>
<noscript><input type="submit" name="_update_view" value="<fmt:message key="update"/>"/></noscript>
</form>

<p>Download:</p>
<form action="<c:url value="${projectEmuExportCtrl.exportArchivePath}"/>">
<c:choose>
<c:when test="${projectEmuExportCtrl.downloadAvailable}">
<input id="archive_link" type="submit" name="_download" value="ZIP Download"/>
</c:when>
<c:otherwise>
<input id="archive_link" disabled type="submit" name="_download" value="ZIP Download"/>
</c:otherwise>
</c:choose>
</form>

</td></tr>
</table>
</body>
</html>
