<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" var="msgs" scope="request"/>
<fmt:setBundle basename="ipsk.db.speech.PropertyNames" var="propNms" scope="request"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message bundle="${msgs}" key="session.details"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message bundle="${msgs}" key="session.details"/></h2>		 
 
<jsp:useBean id="sessionViewCtrl" scope="request" class="ipsk.webapps.db.speech.SessionController"/>
<ips:ctrl_process controller="${sessionViewCtrl}" var="sess">

<ips:bview bean="${sessionViewCtrl.item}" tableClass="dbview" additionalProps="_missingRecordingItems,_sessionDuration,_maxLevel" props="sessionId,uuid,project,status,type,sealed,_missingRecordingItems,date,loadedDate,startedTrainingDate,startedDate,completedDate,lastRestartDate,_sessionDuration,_maxLevel,sealedDate,exportForAnnotation,script,speakers,recordingFiles,comment">

<ips:pview name="_missingRecordingItems" var="mis"  >
<tr><td><fmt:message bundle="${msgs}" key="completeness"/></td>
<td><c:set var="mis" value="${sessionViewCtrl.item.missingRecordingItems}"/>
<c:choose>
<c:when test="${mis == null}">
<!--  n/a  -->
</c:when>
<c:when test="${fn:length(mis)==0}">
<fmt:message bundle="${msgs}" key="complete"/>
</c:when>
<c:otherwise>
<span style="color:red"><fmt:message bundle="${msgs}" key="items.missing"><fmt:param value="${fn:length(mis)}"/></fmt:message></span>
</c:otherwise>
</c:choose></td></tr>
</ips:pview>
<ips:pview name="_sessionDuration" var="sessDur">
<tr><td><fmt:message bundle="${propNms}"  key="duration"/></td>
<c:set var="sessDur" value="${sessionViewCtrl.item.sessionDuration}"/>
<td style="white-space: nowrap;"><c:if test="${sessDur != null}"><fmt:formatNumber value="${sessDur / 1000}" maxFractionDigits="2"/> s</c:if></td></tr>
</ips:pview>
<ips:pview name="_maxLevel" var="recLevel">
<tr><td><fmt:message bundle="${propNms}" key="audio.level.max.in_dB"/></td>
<c:set var="recLevel" value="${sessionViewCtrl.item.maxLevel}"/>
<td style="white-space: nowrap;"><c:if test="${recLevel != null}"><wsp:audioLevelDB linearLevel="${recLevel}"/></c:if></td>
</tr>
</ips:pview>
<ips:pview name="speakers" action="../speaker/Speakers.jsp"/>
<ips:pview name="script" action="../script/ScriptView.jsp"/>
<ips:pview name="recordingFiles" action="recfiles/RecordingFiles.jsp"/>
</ips:bview>

<c:url var="exportUrl" scope="request" value="SessionExport">
<c:param name="sessionId" value="${sessionViewCtrl.item.sessionId}"/>
</c:url>
<a href="<c:out value="${exportUrl}"/>">Export session</a>
</ips:ctrl_process>

</td></tr>
</table>
</body>
</html>
