<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" scope="request"/>
<html>
<head>
<script src="<c:url value="/lib/script/ips_lib.js"/>" type="text/javascript"></script>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="sessions"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="sessions"/></h2>		 
 
<jsp:useBean id="sessDb" scope="session" class="ipsk.webapps.db.speech.SessionController" />
<ips:ctrl_process controller="${sessDb}" processMethod="allSessionsByAccount">
<ips:orderby/><br>
<ips:btable tableClass="db"  additionalCols="_missingRecordingItems,_maxLevel" defColOrder="sessionId,project,date,script,speakers,recordingFiles,_missingRecordingItems,_maxLevel" beanVar="rowSession">
<ips:col name="speakers" href="../speaker/Speakers.jsp" maxListLength="1"/>
<ips:col name="recordingFiles" href="recfiles/RecordingFiles.jsp"/>
<ips:col name="_missingRecordingItems" var="mis"  key="completeness">
<c:set var="mis" value="${rowSession.missingRecordingItems}"/>
<td style="text-align:right">
<c:choose>
<c:when test="${mis == null}">
<!--  n/a  -->
</c:when>
<c:when test="${fn:length(mis)==0}">
<fmt:message key="complete"/>
</c:when>
<c:otherwise>
<span style="color:red"><fmt:message key="items.missing"><fmt:param value="${fn:length(mis)}"/></fmt:message></span>
</c:otherwise>
</c:choose></td>
</ips:col>
<ips:col name="_maxLevel" var="recLevel" bundle="ipsk.db.speech.PropertyNames" key="audio.level.max.in_dB">
<c:set var="recLevel" value="${rowSession.maxLevel}"/>
<td style="text-align:right"><c:if test="${recLevel != null}"><wsp:audioLevelDB linearLevel="${recLevel}"/></c:if></td>
</ips:col>
<ips:btrowaction href="${sessDb.getSpeechRecorderBaseHref(rowSession)}" name="speechrecorder.start"><i class="material-icons">launch</i> <c:choose><c:when test="${empty rowSession.script}"><fmt:message key="audiorecorder.start"/></c:when><c:otherwise><fmt:message key="speechrecorder.start"/></c:otherwise></c:choose></ips:btrowaction>
<ips:btrowaction href="SessionExport" name="export"><i class="material-icons">archive</i> <fmt:message key="export"/></ips:btrowaction>
</ips:btable>
<ips:page_navigation/>
<ips:page_position/>
<ips:items_position/>
</ips:ctrl_process>

</td></tr>
</table>
</body>
</html>
