/*
 * Created on May 30, 2005
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package ipsk.webapps.db.servlets;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collection;

import javax.persistence.EntityManager;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import ips.servlet.http.MultipartUtils;
import ipsk.apps.speechrecorder.script.RecscriptHandler;
import ipsk.apps.speechrecorder.script.RecscriptHandlerException;
import ipsk.db.speech.script.Script;
import ipsk.db.speech.utils.ImportException;
import ipsk.db.speech.utils.ScriptImporter;
import ipsk.io.StreamCopy;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.xml.DOMConverterException;

/**
 * Servlet imports Speechrecorder XML script from fiel upload form
 * 
 * @author klausj
 * 
 */
@MultipartConfig()
public class ImportScriptServlet extends HttpServlet {

	public static final String NAME = "session";
	
	private static volatile Charset cs;
	private static String CS_NAME="UTF-8";

	private ScriptImporter scriptImporter;

	public void init() throws ServletException {
		super.init();
		cs=Charset.forName(CS_NAME);
		scriptImporter = new ScriptImporter();
	}
	
	private Script importScript(EntityManager em,InputSource is,String assProjId) throws DOMConverterException, IOException, ParserConfigurationException, SAXException, ImportException, RecscriptHandlerException{

		// use speechrecorders handler
		RecscriptHandler rsh = new RecscriptHandler();

		Script scriptFromXMLDoc = rsh.readScriptFromXMLwithoutDTD(is);
		Script s=scriptImporter.importScript(em, scriptFromXMLDoc,assProjId);

		String msg = "Script successfully imported. Script ID is: "+s.getScriptId();
		log(msg);

		return s;

	}
	

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		
		String assProjId=null;
		Part assprojIdPart = request.getPart("project.name");
		if(assprojIdPart!=null){
			InputStream is=assprojIdPart.getInputStream();
			assProjId=StreamCopy.readTextStream(is,cs);
		}
		
		EntityManager em = EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		Exception ex=null;
		String currFilename=null;
		Script s=null;
		int importCnt=0;
		Collection<Part> parts=request.getParts();
		for(Part p:parts){
			
			String pName=p.getName();
			if("recscript".equals(pName)){
				//String filename=fPart.getSubmittedFileName(); // TODO Requires Servlet API 3.1.0 (Ubuntu 16.04 ?) 
				currFilename=MultipartUtils.partFilename(p);
				
				InputStream ist = p.getInputStream();
				BufferedInputStream pbis=new BufferedInputStream(ist);
				// Do _NOT_ wrap the stream by a reader here
				// With a reader scripts with BOM cannot be parsed!
				// Buffering may be required for the parser to handle the BOM (stream mark/reset)
				
				InputSource is = new InputSource(pbis);
				
				try{
					s=importScript(em, is, assProjId);
					importCnt++;	
				} catch (Exception e) {
					String msg = "Could not import Speechrecorder recording script: " + e.getMessage();
					log(msg);
					ex=e;
					break;
				}
			}
		}
		String ruri=request.getRequestURI();
		String cburi=ruri.replaceFirst("servlet$","");
		if(ex==null){
			if(importCnt==0){
				String msg = "No Speechrecorder recording script found in upload";
				log(msg);
				//response.sendError(500, msg);
				String encMsg=URLEncoder.encode(msg,"UTF-8");
				
				response.sendRedirect(cburi+"ScriptImportConfirm.jsp?_errMsg="+encMsg);
			}else if(importCnt==1){
				response.sendRedirect(cburi+"/ScriptImportConfirm.jsp?scriptId="+s.getScriptId());
			}else{
				response.sendRedirect(cburi+"/ScriptImportConfirm.jsp?_size="+importCnt);
			}
		}else{
			String msg;
			if(currFilename!=null){
				msg = "Could not import Speechrecorder recording script : "+currFilename+", cause: " + ex.getMessage();
			}else{
				msg = "Could not import Speechrecorder recording script(s): " + ex.getMessage();
			}
			log(msg);

			//response.sendError(500, msg);
			
			String encMsg=URLEncoder.encode(msg,"UTF-8");
			response.sendRedirect(cburi+"/ScriptImportConfirm.jsp?_errMsg="+encMsg);
		}
		
//		
//		Part xmlPart = request.getPart("recscript");
//		Part xmlParts = request.getPart("recscripts");
//		if (xmlPart == null && xmlParts==null) {
//			response.sendError(500, "No recscript uploaded. (part recscript(s) not found)");
//			return;
//		}
//		
//		if(xmlPart!=null){
//
//			InputStream ist = xmlPart.getInputStream();
//			Reader isr=new InputStreamReader(ist,cs);
//			InputSource is = new InputSource(isr);
//			EntityManager em = EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
//			try{
//				Script s=importScript(em, is, assProjId);
//				// TODO redirect has fixed URL for admin area 
//				response.sendRedirect(request.getContextPath()+"/db/script/ScriptImportConfirm.jsp?scriptId="+s.getScriptId());
//			} catch (Exception e) {
//				String msg = "Could not import Speechrecorder recording script: " + e.getMessage();
//				log(msg);
//
//				response.sendError(500, msg);
//			} finally {
//				em.close();
//			}
//		}else if(xml)
	}

}
