package ipsk.webapps.db.speech;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

import ipsk.db.speech.Account;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.Project;
import ipsk.db.speech.account.AccountRequest;
import ipsk.db.speech.account.InvitationRequest;
import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.QueryParam;
import ipsk.webapps.ControllerException;
import ipsk.webapps.ProcessResult;


public class InvitationRequestController extends BasicWikiSpeechController<InvitationRequest>{

	protected InvitationUtils invitationUtils;

	public InvitationRequestController() {
		super("WebSpeechDBPU",InvitationRequest.class);
		invitationUtils=new InvitationUtils();
	}


	private List<InvitationRequest> associatedInvitationRequests(EntityManager em, Account acc){
		List<InvitationRequest> assInvReqs=new ArrayList<InvitationRequest>();
		if(acc!=null) {
			Set<Project> admProjs=acc.getAdminOfProjects();
			CriteriaBuilder cb = em.getCriteriaBuilder();

			CriteriaQuery<AccountRequest> cq = cb.createQuery(AccountRequest.class);
			Root<AccountRequest> qr = cq.from(AccountRequest.class);
			cq.select(qr);
			TypedQuery<AccountRequest> aq = em.createQuery(cq);
			List<AccountRequest> accReqs=aq.getResultList();

			for(AccountRequest accReq:accReqs){
				if(accReq instanceof InvitationRequest){
					InvitationRequest ir=(InvitationRequest)accReq;
					Organisation orga=ir.getOrganisation();
					List<Project> projs=ir.getProjects();
					if(projs!=null) {
						for(Project admProj:admProjs) {
							String admProjNm=admProj.getName();
							for(Project prj:projs) {
								if(admProjNm.equals(prj.getName())) {
									assInvReqs.add(ir);
									continue;
								}
							}
						}
					}
					if(orga!=null) {
						Set<Project> orgaPrjs=orga.getProjects();
						for(Project admProj:admProjs) {
							if(orgaPrjs.contains(admProj)) {
								assInvReqs.add(ir);
								continue;
							}
						}
					}
				}
			}
		}
		return assInvReqs;
	}

	// used anywhere ?
	public List<InvitationRequest> getAssociatedInvitationRequests(){
		EntityManager em=getThreadEntityManager();
		Account acc=AccountController.getAccountByRequest(currentRequest, em);
		List<InvitationRequest> assInvs=associatedInvitationRequests(em,acc);
		return assInvs;
	}
	
	
	public void associatedInvitationRequests(HttpServletRequest req) throws ControllerException{
		clear();
		createEmptyBeanTableModel(req);
		
		Account acc=getAccountByRequest(req);
		if(acc==null)return;
		EntityManager em=getThreadEntityManager();
		List<InvitationRequest> assInvs=associatedInvitationRequests(em,acc);
		for(InvitationRequest invReq:assInvs) {
			getSecurityManager().checkReadPermission(req, invReq);
		}
	
		// Do not use pages
		beanTableModel.notPageableItems(assInvs);
		
		beanTableModel.setExtBeanInfo(getBeanInfo());
		processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
	}
	
	
	public String invitationLink() throws JspException{
		
		String link=null;
		InvitationRequest ir;
		try {
			ir = getItem();
			if(ir!=null) {
				UUID irUUID=ir.getUuid();
				if(irUUID!=null && currentRequest !=null) {
					link=invitationUtils.invitationLink(currentRequest, irUUID);
				}
			}
		} catch (ControllerException e) {
			throw new JspException(e);
		}
		return link;
	}

}
