package ipsk.webapps.db.speech.project;

import java.io.File;
import java.nio.file.Path;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import ipsk.webapps.db.servlets.FileServer;

public class ProjectHelper {

	private File baseDir=null;
	
	public File getBaseDir() {
		return baseDir;
	}

	public void applyResourcesDir(ServletContextEvent sce) {
		ServletContext servletContext=sce.getServletContext();
		String baseDirPath = servletContext.getInitParameter(FileServer.BASE_DIR_PARAMETER_KEY);
		if(baseDirPath!=null){
			baseDir=new File(baseDirPath);
			servletContext.log("Base directory set on context initialize: "+baseDir);
		}
	}
	
	public Path dirPath(File baseDir,String projectName) {
		Path dir=null;
		if(baseDir==null) {
			baseDir=this.baseDir;
		}
		if(projectName!=null) {
			Path projectsPath=baseDir.toPath().resolve(FileServer.PROJECTS_DIR);
			dir=projectsPath.resolve(projectName);
		}
		return dir;
	}
	
	public Path dirPath(String projectName) {
		return dirPath(null, projectName);
	}
	
	public Path resourcesDirPath(File baseDir,String projectName) {
		Path resDir=null;
		Path dir=dirPath(baseDir,projectName);
		if(dir!=null) {
			resDir=dir.resolve(FileServer.RESOURCES_DIR);
		}
		return resDir;
	}
	
	public Path resourcesDirPath(String projectName) {
		return resourcesDirPath(null,projectName);
	}
	
}
