<!DOCTYPE html>
<%@ page language="java" contentType="text/html; charset=UTF-8" import="ipsk.webapps.*,java.util.*" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<fmt:setBundle basename="Messages" scope="request"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html;UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - Project administrator manual</title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 
 <td class="content">		 
 <h2>Project administrator manual</h2>
 
 <%
if (request.isUserInRole(ipsk.db.speech.UserRoleId.RoleName.PROJECT_ADMIN.name())){ %>

<!--  project admin  docs-->
	<h3>Your role as project administrator on WikiSpeech</h3>
		<p>Your WikiSpeech user account has the privilege to manage WikiSpeech projects. This allows you to change the configuration of your projects, invite speakers or conduct recording sessions. You can monitor and delete recording sessions and their recording files.</p>
	<h3>General notes to the user interface</h3>
	<p>The current user interface (UI) to configure your project is not very modern and sometimes not very intuitive especially when handling collection properties. In some forms a back link is missing. It is often required to start the navigation to an entity again from the main menu.</p>
	<p>The UI often makes use of the hash character to indicate collections and the number of items in the collection: #[number of items] e.g. #3 means a collection of 3 items. In many cases this is a link which will lead to a page with the list of these items.</p>
 	<h3>Project configuration</h3>
 		<p>Login to WikiSpeech to configure your project. Click on 'Projects' in the menu to get the list of your projects.</p>
 		<p>Configure a project by clicking on the '[Edit]' action of a project entry in your project list.</p>  
 		<h4>Required configuration items</h4>
 			<h5>Research purpose</h5>
 			<p>Please enter a short description of your research purpose.</p>
 			<p>If you plan a multi-language project please select the primary language for the research purpose field. Then you can enter additional translations with the project property 'Default research purpose additional languages'.</p>
 		<h4>Informed Consent configuration</h4>
 		<p>There are three ways to configure the informed consent:</p>
 		<p>For each speaker an informed consent is required. 
 		<ol>
 			<li>Use the WikiSpeech standard informed consent. You only need to enter the 'Default research purpose' for this.</li>
 			<li>Most projects require a more customized informed consent. Please enter your customized text to the field 'Text of the informed consent'. You can add additional translations with the property 'Informed consent texts in additional languages'.</ul>
 			<li>If you want to use an informed consent in paper form please set 'Informed consent in paper form' to 'Yes'. (The text of property 'Text of the informed consent' will then be ignored.)</li>
 		</ol>
 		<p>A new speaker has to confirm the informed consent by activating a check box. For options 1. and 2. the informed consent text will be stored in the speaker record. For option 3. it will only be stored, that the speaker has accepted the consent in paper form.</p>
 		<p>Please test the informed consent by clicking on 'New speaker' in the menu.</p>
 		<h4>Speaker form</h4>
 		<p>If your project requires the storage of a speaker code or some speaker properties it is required to create at least one speaker form. The forms of your project are managed with the property 'Own forms'.</p>
 		<p>To create a new form:</p>
 		<ol>
 			<li>Click on '[Add]' in 'Own forms' property. The 'New form' speaker form will appear.</li>
 			<li>A default 'Display name' is already filled. Optionally add an description for this speaker form.</li>
 			<li>Press 'Save'. Now an empty (it has no form properties yet) speaker form is added.</li>
 			<li>Click on the forms collection (e.g. #1) in the 'Own forms' property to edit the form(s). A list of your speaker forms will be shown.</li>
 			<li>Click on '[Edit]' to edit and add properties to a speaker form. The edit page for the form will be shown.</li>
 			<li>Click on 'Property configurations' '[Add new]' to add a speaker form property. The 'New property configuration' will appear.</li>
 			<li>Select a 'Name' and if the property should be 'Required' to be filled by the subject.</li>
 			<li>Other speaker form properties can be added the same way</li>
 		</ol>
 		<p>The speaker form can as well be tested by clicking on 'New speaker' in the menu.</p>
 		<h4>Recording script(s)</h4>
 		<h5>Recording script store</h5>
 		<p>The recording session may be controlled by one or more <a href="https://www.bas.uni-muenchen.de/Bas/software/speechrecorder/">SpeechRecorder</a> recording script(s). SpeechRecorder recording scripts are Extensible Markup Language (XML) files. Please use the <a href="https://www.bas.uni-muenchen.de/Bas/software/speechrecorder/manual/latest/html/SpeechRecorderUserManual/index.html">SpeechRecorder documentation</a> to create a recording script.
 		<p>Your can store multiple recording scripts for your project. The project owned scripts can be managed with the project property 'Own scripts'. Use '[Import script]' to import a script from an XML file. To view the scripts click on the hash symbol.</p>
 		<h5>Activation</h5>
 		<p>Only activated scripts will be used for recording sessions. Activate a script from list of own scripts i the property 'Active scripts' by clicking on '[Add]' and selecting one or more recording scripts.</p>
 		<p>If at least one script is activated a recording session will be conducted with the WebSpeechRecorder otherwise a simple audio recorder will be started.</p>
 		<h5>Multiple scripts</h5>
 		<p>If you want to use more then one recording script it will be determined by the property 'Script selection mode' which script will be selected for a new recording session:
 		<ul>
 		<li>'Least usage' (default): The script that has been least used for recording sessions will be selected. It is intended to provide an even distribution of sessions across scripts.</li>
 		<li>'Manual': Let the subject select the recording script. For this it is important to set a human readable name to the recording scripts (XML attribute 'id').
 		</ul> 
 	<h3>Test your project</h3>
 		<p>You should do some test sessions before starting with the project. The test sessions can be deleted.</p>
 	<h3>Project procedure</h3>
 	 <p>The project procedure depends on the projects needs. We will give some examples for typical scenarios here.</p>
 	 <h4>Unattended recording sessions</h4>
 	 <p>The subject will be invited by e-mail or in paper form and conducts the recording session himself. Project administrators may monitor the recordings.</p>
 	 <p>The invitation e-mail contains only a short welcome and link to create the WikiSpeech user account. It is recommended to send the subjects a separate e-mail with more detailed informations about participation in the project. Or you may use 'Provide invitation link' in the 'Realisation of invitation' property of the 'Invite speaker' form. WikiSpeech will only display the invitation link for copy and paste and not send a invitation e-mail then.</p>
 	 <p>Invitations are valid for some days. If an invitation expires an the subject still wants to participate you can just send a new invitation. You can view pending invitations by clicking on the 'Invitations' menu item.</p> 
 	<ul>
 		<li><h5>Invite speaker</h5>
 			<p>A speaker/subject can be invited by E-Mail. The speaker receives an E-Mail that contains an URL that lets the speaker create an WikiSpeech account. Click in the link 'Speaker invitation' at the bottom of the project edit page.</p>
 		</li>
 		<li><h5>Subject account</h5>
 			<p>The subject creates an account on the WikiSpeech platform by clicking on the link in his invitation e-mail. The name of the account is his E-Mail address.</p>
 			<p>The speaker is now able to login to WikiSpeech.</p>
 		</li>
 		<li><h5>Speaker data and informed consent form</h5>
 			<p>Before the speaker starts a recording session he has to fill the speaker form (optionally) and has to accept the informed consent. The data is stored once and the speaker can start with the recording session(s).</p>
 			</li>
 		<li><h5>Recording session form</h5>
 			<p>If the user starts a new recording session, he might optionally be asked to select a recording script and may optionally leave a comment for this session.</p>
 			</li>
 		</ul>
 		<h4>Recording sessions attended by a project administrator</h4>
 	 <p>The project administrator attends the recordings.</p>
 	 <ul>
 	 <li>Login as project administrator and select a project (if you have more than one project).</li>
 	 <li>Click on the link 'New Speaker' in the left side menu.</li>
 	 </ul>
 	 <h4>Members of a partner organization attend the recording sessions</h4>
 	 <p>A known member of an organization will be invited to create an WikiSpeech organization account. The member will conduct the recording sessions of the subjects. Organizations are for example other research institutions, schools or medical practices.</p>
 	 <p>Click on 'Organisations' in the menu to manage your participating organizations.</p>
 	 
 	 <h4>Procedure of a recording session</h4>
 	 <ol>
 	 <li><h5>Speaker data and informed consent form</h5>
 			<p>Before you start the recording session for the speaker the speaker form (optionally) and the informed consent has to be accepted. The data is stored once and the speaker can start with the recording session(s).</p>
 			</li>
 	<li><h5>Recording session form</h5>
 			<p>If the user starts a new recording session, he might optionally be asked to select a recording script and may optionally leave a comment for this session.</p>
 			</li>
 	<li><h5>Recording session</h5>
 			<p>When all necessary data was entered the actual recording session begins. The recordings are uploaded asynchronously in the background to the server.</p>
 			</li>
 		<li><h5>Quality check</h5>
 			<p>Project adminstrators should check the recordings for technically and semantically quality. The recording files of a session are listed by clicking on the 'Recording files' column in the sessions list.</p>
 			</li>
 		<li><h5>Complete/correct session</h5>
 			<p>Each recording session can be restarted to record some items again or complete a session.</p>
 			</li>
 		<li><h5>Recording session export</h5>
 			<p>Project adminstrators can export and download the recording sessions as archive files from WikiSpeech.</p>
 			</li>
 	</ol>
 	<h4>Pseudonymization</h4>
 	<p>The speaker data record and the recordings are initially connected to the user account of the speaker and therefore not pseudonymized. The user account must be deleted to pseudonymize the speaker data and recordings. The subject can either delete its user account itself or the project administrator can do this. The speaker data and the recordings of the subject are <b>not</b> deleted together with the subject account. If the speaker form only asks for anonymous speaker properties the recording sessions of the user are pseudonymized when the corresponding account is deleted.</p>
 	<h4>Clean/remove project</h4>
 	<p>If the project has finished and the recording session data is completely downloaded project adminstrators should delete the project from WikiSpeech.</p>
	<p>Click on [Delete] in the projects list to completely remove your project. The deletion dialog will first request you to delete the recording sessions before it is possible to finally remove the project.</p>
 <% } %>
 

</td></tr>
</table>
</body>
</html>
