<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"  %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" scope="request"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="project.delete"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="project.delete"/></h2>

<jsp:useBean id="projectDeleteCtrl" scope="request" class="ipsk.webapps.db.speech.ProjectController" />
<ips:ctrl_process controller="${projectDeleteCtrl}" checkSecureRequestToken="true" processMethod="deleteProject">
<ips:ctrl_div>

<c:choose>
<c:when test="${projectDeleteCtrl.projectDeletable()}">

<ips:bview bean="${projectDeleteCtrl.item}" action="/prjdb/project/ProjectDelete.jsp" actionCommand="delete" props="name,uuid,description,organisations,accounts,adminAaccounts,ownedForms,ownedScripts,sessions" tableClass="db">
	<ips:pview name="ownedForms" cssWarnOnNonEmptyColl="true"/>
	<ips:pview name="ownedScripts" cssWarnOnNonEmptyColl="true"/>
</ips:bview>


<p class="warn"><fmt:message key="deletion.cannot.be.undone"/></p>

</c:when>
<c:otherwise>

<ips:bview bean="${projectDeleteCtrl.item}" props="name,uuid,description,organisations,accounts,adminAccounts,ownedForms,ownedScripts,sessions" tableClass="dbview">
<ips:pview name="organisations" var="orgas">
<c:choose>
<c:when test="${fn:length(projectDeleteCtrl.item.organisations)>0 && fn:length(projectDeleteCtrl.item.sessions)==0}">
<tr><td><ips:pdescr/></td><td><ips:pseldelete href="/prjdb/organisation/OrganisationsSelectToRemove.jsp?projects.name=${projectDeleteCtrl.item.name}"><fmt:message key="organisations.list_delete"/>...</ips:pseldelete></td></tr>
</c:when>
<c:otherwise>
<tr><td><ips:pdescr/></td><td><a href="<ips:brelurl action="/prjdb/organisation/OrganisationsOfProject.jsp"/>"><c:out value="#${fn:length(projectDeleteCtrl.item.organisations)}"/></a></td></tr>
</c:otherwise>
</c:choose>
</ips:pview>
<ips:pview name="accounts" var="accs">
<c:if test="${projectDeleteCtrl.hasProjectSubjectAccounts()}">
<tr><td><ips:pdescr/></td><td><ips:pseldelete href="/prjdb/account/AccountsSubjectOnly.jsp?projects.name=${projectDeleteCtrl.item.name}"><fmt:message key="accounts.subject.list_delete"/>...</ips:pseldelete></td></tr>
</c:if>
</ips:pview>
<ips:pview name="adminAccounts" action="/prjdb/account/Accounts.jsp"/>
<ips:pview name="sessions" var="prjSesss">
<c:choose>
<c:when test="${fn:length(projectDeleteCtrl.item.sessions)>0}">
<tr><td><ips:pdescr/></td><td><c:out value="#${fn:length(projectDeleteCtrl.item.sessions)}"/> <ips:pseldelete href="/prjdb/session/SessionsOfProjectDelete.jsp?project.name=${projectDeleteCtrl.item.name}">List/Delete sessions...</ips:pseldelete></td></tr>
</c:when>
<c:otherwise>
<tr><td><ips:pdescr/></td><td><a href="<ips:brelurl action="/prjdb/session/Sessions.jsp"/>"><c:out value="#${fn:length(projectDeleteCtrl.item.sessions)}"/></a></td></tr>
</c:otherwise>
</c:choose>
</ips:pview>

</ips:bview>

<c:set var="resourceFsCounts" value="${projectDeleteCtrl.resourceFilesystemCounts()}" />
<c:if test="${not empty resourceFsCounts and not resourceFsCounts.isEmpty()}">
 <p>Project resources: <c:out value="${resourceFsCounts.numberOfDirectories}"/>  directories and <c:out value="${resourceFsCounts.numberOfRegularFiles}"/> regular files.  
  <c:url var="projectResUrl" scope="request" value="/prjdb/project/resources/Resources.jsp">
   <c:param name="project.name" value="${projectDeleteCtrl.item.name}"/>
  </c:url>
  <a href="<c:out value="${projectResUrl}"/>"><fmt:message key="project.resources"/></a></p>
</c:if>

<p><fmt:message key="project.delete.instructions"/></p>

</c:otherwise>
</c:choose>

</ips:ctrl_div>
<ips:ctrl_div result="success">
<p><fmt:message key="project.delete.confirm"><fmt:param value="${projectDeleteCtrl.item.name}"/></fmt:message></p>
</ips:ctrl_div>
<ips:ctrl_div result="cancel">
<p><fmt:message key="cancelled"/></p>
</ips:ctrl_div>
</ips:ctrl_process>
</td></tr>
</table>
</body>
</html>
