<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" scope="request"/>
<fmt:setBundle basename="ipsk.db.speech.PropertyNames" scope="request" var="bndlSpDb"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="project.edit"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="project.edit"/></h2>
<jsp:useBean id="projectEditCtrl" scope="session" class="ipsk.webapps.db.speech.ProjectController" />
<jsp:useBean id="defaultMediaCaptureFormat" scope="session" class="ipsk.db.speech.project.MediaCaptureFormat" />
<jsp:useBean id="defaultMediaStorageFormat" scope="session" class="ipsk.db.speech.project.MediaStorageFormat" />

<ips:ctrl_process controller="${projectEditCtrl}" checkSecureRequestToken="true">

<c:url var="scriptImportUrl" scope="request" value="/prjdb/script/ScriptImport.jsp">
<c:param name="project.name" value="${projectEditCtrl.item.name}"/>
</c:url>

<ips:bform bean="${projectEditCtrl.item}" action="/prjdb/project/ProjectEdit" actionCommand="store" beanIdPropertyVar="bIdProp" beanIdVar="bId" props="name,uuid,description,defaultResearchPurpose,defaultResearchPurposeLanguageISO3code,defaultResearchPurposeAdditionalLanguages,defaultInformedConsentText,defaultInformedConsentTextLanguageISO3code,informedConsentTextAdditionalLanguages,enableBroadConsent,informedConsentPaperForm,ownedForms,speakerFormConfiguration,dialectRegions,organisations,accounts,recordingDeviceWakeLock,audioDevices,audioFormat,mediaCaptureFormat,autoGainControlConfigs,allowEchoCancellation,chunkedRecording,mediaStorageFormat,clientAudioStorageType,ownedScripts,scripts,scriptSelectionMode,showSessionCompleteMessage,sessions,informedConsents,allowPublicPseudonymizedAudioExport" tableClass="db">

<ips:pedit name="defaultResearchPurposeLanguageISO3code" var="drplic">
<tr><td><ips:pdescr/></td><td><ips:languageSelect standard="ISO-639-3" name="defaultResearchPurposeLanguageISO3code" value="${drplic}" nullable="true"/></td></tr>
</ips:pedit>

<ips:pedit name="defaultResearchPurposeAdditionalLanguages" var="drpal">
<tr><td><ips:pdescr/></td>
<td><a href="<ips:brelurl action="LocalizedDefaultResearchPurposeTexts.jsp"/>">#<c:out value="${fn:length(drpal)}"/></a> <ips:paddnew href="LocalizedDefaultResearchPurposeTextNew.jsp"/> <ips:pseldelete href="LocalizedDefaultResearchPurposeTexts.jsp"/></td></tr>
</ips:pedit>


<ips:pedit name="defaultInformedConsentTextLanguageISO3code" var="dictlic">
<tr><td><ips:pdescr/></td><td><ips:languageSelect standard="ISO-639-3" name="defaultInformedConsentTextLanguageISO3code" value="${dictlic}" nullable="true"/></td></tr>
</ips:pedit>

<ips:pedit name="informedConsentTextAdditionalLanguages" var="ictal">
<tr><td><ips:pdescr/></td>
<td><a href="<ips:brelurl action="LocalizedInformedConsentTexts.jsp"/>">#<c:out value="${fn:length(ictal)}"/></a> <ips:paddnew href="LocalizedInformedConsentTextNew.jsp"/> <ips:pseldelete href="LocalizedInformedConsentTexts.jsp"/></td></tr>
</ips:pedit>

<ips:pedit name="ownedForms" var="ofrms">
<c:if test="${empty projectEditCtrl.item.speakerFormConfiguration or not empty projectEditCtrl.item.speakerFormConfiguration.owningProject}">
<tr><td><ips:pdescr/></td>
<td><a href="<ips:brelurl action="/prjdb/project/form/ProjectForms.jsp"/>">#<c:out value="${fn:length(ofrms)}"/></a> <ips:paddnew href="/prjdb/project/form/ProjectFormNew.jsp"/></td></tr>
</c:if>
</ips:pedit>

<ips:pedit name="speakerFormConfiguration" var="spkFm">
<tr>
<td><ips:pdescr/></td>
<td>
<c:choose>
  <c:when test="${empty spkFm}">
   	<fmt:message key="none"/> <ips:pselset href="/prjdb/project/form/ProjectSpeakerForms.jsp"/>
  </c:when>
  <c:otherwise>
  	<c:choose>
  <c:when test="${empty spkFm.owningProject}">
   	<c:out value="${spkFm}"/>
  </c:when>
  <c:otherwise>
   <c:out value="${spkFm}"/> <ips:pselset href="/prjdb/project/form/ProjectSpeakerForms.jsp"/> <ips:pselreset href="/prjdb/project/form/ProjectSpeakerForms.jsp"/>
  </c:otherwise>
</c:choose>
  </c:otherwise>
</c:choose>
</td>
</tr>
</ips:pedit>


<ips:pedit name="organisations" var="orgs">
<tr><td><ips:pdescr/></td>
<td>
<c:if test="${empty orgs}">
<fmt:message key="organisation.none_selected"/><input type="hidden" name="organisations._set_null" value="null"/>
</c:if>
<c:if test="${not empty orgs}">
<table>
<c:forEach items="${orgs}" var="org"><tr><td><c:out value="${org.name}"/><input type="hidden" name="organisations.organisationId" value="<c:out value="${org.organisationId}"/>"/></td></tr> </c:forEach>
</table>
</c:if><c:url var="orgaAddUrl" value="/prjdb/organisation/Organisations.jsp"><c:param name="projects.name" value="${projectEditCtrl.item.name}"/></c:url> <ips:pseladd href="/prjdb/organisation/Organisations.jsp?projects.name=${projectEditCtrl.item.name}"/> <ips:pselremove href="/prjdb/organisation/OrganisationsSelectToRemove.jsp"/>
</td></tr>
</ips:pedit>


<ips:pedit name="accounts" var="accs">
<tr><td><ips:pdescr/></td>
<td>
<c:if test="${empty accs}">
<fmt:message key="none"/><input type="hidden" name="accounts._set_null" value="null"/>
</c:if>
<c:if test="${not empty accs}">
 <c:choose>
 <c:when test="${fn:length(accs) < 10}">
<table>
<c:forEach items="${accs}" var="acc"><tr><td><c:out value="${acc.login}"/><input type="hidden" name="accounts.login" value="<c:out value="${acc.login}"/>"/></td></tr> </c:forEach>
</table>
 </c:when>
 <c:otherwise>
 	<a href="<ips:brelurl action="../account/Accounts.jsp"/>">#<c:out value="${fn:length(accs)}"/></a>
 </c:otherwise>
 </c:choose>
</c:if>
</td></tr>
</ips:pedit>

<ips:pedit name="ownedScripts" var="oscrs">
<tr><ips:btpdescrtd/>
<td><a href="<ips:brelurl action="/prjdb/script/ProjectOwningScripts.jsp"/>">#<c:out value="${fn:length(oscrs)}"/></a> [<a href="<c:out value="${scriptImportUrl}"/>"><fmt:message key="script.import"/></a>]</td></tr>
</ips:pedit>

<ips:pedit name="recordingDeviceWakeLock" defaultOptionResourceKey="application.default.no"/>

<ips:pedit name="chunkedRecording" defaultOptionResourceKey="application.default.no"/>

<ips:pedit name="clientAudioStorageType" defaultOptionResourceKey="storage.type.app_default.mem_entire" defaultOptionResourceBundle="ipsk.db.speech.PropertyNames"/>

<ips:pedit name="audioFormat" var="af">
	<c:if test="${not empty af}">
		<tr><td><ips:pdescr/></td><td><c:out value="${af}"/></td></tr>
	</c:if>
</ips:pedit>

<ips:pedit name="mediaCaptureFormat" var="mcf">
	<c:if test="${empty projectEditCtrl.item.audioFormat}">
	<c:set var="currMcf" scope="request" value="${defaultMediaCaptureFormat}"/>
	<c:if test="${not empty projectEditCtrl.item.mediaCaptureFormat}">
	 <c:set var="currMcf" scope="request" value="${projectEditCtrl.item.mediaCaptureFormat}"/>
	</c:if>
	<c:url value="MediaCaptureFormatEdit.jsp" var="mcfEditUrl">
		<c:param name="_cmd" value="edit_or_new"/>
		<c:param name="name" value="${projectEditCtrl.item.name}"/>
	</c:url>
		<tr>
			<td><ips:pdescr/></td>
			<td><c:out value="${currMcf}"/> <a href="<c:out value="${mcfEditUrl}"/>">[<fmt:message key="edit"/>]</a></td>
		</tr>
	</c:if>
</ips:pedit>

<ips:pedit name="mediaStorageFormat" var="msf">
	<c:if test="${empty projectEditCtrl.item.audioFormat}">
	<c:set var="currMsf" scope="request" value="${defaultMediaStorageFormat}"/>
	<c:if test="${not empty projectEditCtrl.item.mediaStorageFormat}">
	 <c:set var="currMsf" scope="request" value="${projectEditCtrl.item.mediaStorageFormat}"/>
	</c:if>
	<c:url value="MediaStorageFormatEdit.jsp" var="msfEditUrl">
		<c:param name="_cmd" value="edit_or_new"/>
		<c:param name="name" value="${projectEditCtrl.item.name}"/>
	</c:url>
		<tr>
			<td><ips:pdescr/></td>
			<td><c:out value="${currMsf}"/> <a href="<c:out value="${msfEditUrl}"/>">[<fmt:message key="edit"/>]</a></td>
		</tr>
	</c:if>
</ips:pedit>

<ips:pedit name="autoGainControlConfigs" var="agccs">
<tr><td><ips:pdescr/></td>
<td><a href="<ips:brelurl action="AutoGainControlConfigs.jsp"/>">#<c:out value="${fn:length(agccs)}"/></a> <ips:paddnew href="AutoGainControlConfigNew.jsp"/> <ips:pseldelete href="AutoGainControlConfigs.jsp"/></td></tr>
</ips:pedit>

<ips:pedit name="allowEchoCancellation" defaultOptionResourceKey="application.default.no"/>

<ips:pedit name="scripts" var="scrs">
<tr><ips:btpdescrtd/>
<td><a href="<ips:brelurl action="/prjdb/script/ActiveScripts.jsp"/>">#<c:out value="${fn:length(scrs)}"/></a> <ips:pseladd href="/prjdb/script/NonActiveScripts.jsp"/> <ips:pselremove href="/prjdb/script/ActiveScripts.jsp"/></td></tr>
</ips:pedit>

<ips:pview name="sessions" action="/prjdb/session/Sessions.jsp" />

</ips:bform>

<p><fmt:message key="help.research.purpose.default" bundle="${bndlSpDb}"/></p>

<c:url var="inviteSpkUrl" scope="request" value="/prjdb/project/InviteSpeaker.jsp">
<c:param name="project.name" value="${projectEditCtrl.item.name}"/>
</c:url>
<p><a href="<c:out value="${inviteSpkUrl}"/>"><fmt:message key="speaker.invite"/></a></p>

<c:url var="inviteMultipleSpksUrl" scope="request" value="/prjdb/project/InviteMultipleSpeakers.jsp">
<c:param name="project.name" value="${projectEditCtrl.item.name}"/>
</c:url>
<p><a href="<c:out value="${inviteMultipleSpksUrl}"/>"><fmt:message key="speaker.invite.multiple"/></a></p>

<c:url var="projectResUrl" scope="request" value="/prjdb/project/resources/Resources.jsp">
<c:param name="project.name" value="${projectEditCtrl.item.name}"/>
</c:url>
<p><a href="<c:out value="${projectResUrl}"/>"><fmt:message key="project.resources"/></a></p>


</ips:ctrl_process>

</td></tr>
</table>
</body>
</html>
