<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" import="ipsk.beans.*" %>
<fmt:setBundle basename="Messages" scope="request"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="speaker.edit"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="speaker.edit"/></h2>		 
 
<jsp:useBean id="spkCtrl" scope="session" class="ipsk.webapps.db.speech.SpeakerInformedConsentController"/>
<jsp:setProperty name="spkCtrl" property="formConfigurationFromProject" value="true"/>
<ips:ctrl_process controller="${spkCtrl}" var="spk" checkSecureRequestToken="true">
<ips:ctrl_div>
<ips:bform actionCommand="store" props="*">

<ips:pedit name="height" editUnit="cm"/>

<ips:pedit name="organisations">
<c:set var="orgaByAcc" value="${spkCtrl.associatedOrganisation}" scope="request"/>
<c:if test="${orgaByAcc != null}">
<input type="hidden" name="organisations.organsiationId" value="${orgaByAcc.organisationId}"/>
</c:if>
</ips:pedit>

<ips:pedit name="dialectRegion">
<tr><td><ips:pdescr/></td><td><select name="dialectRegion.dialectRegionId">
     <!--  TODO handle zero size dialect regions list -->
         <c:forEach var="dr" items="${spkCtrl.orderedDialectRegionsForSelectedProject}">
        <!-- TODO default selection  -->		
       <option value="${dr.dialectRegionId}"><c:out value="${dr.name}"/></option>
       </c:forEach>
     </select></td></tr>

</ips:pedit>

<ips:pedit name="informedConsent">
<tr style="margin: 2em"><td colspan="2"><div>
    <input type="checkbox" id="subscribeInformedConsent" name="informedConsent" value="<c:out value="${spkCtrl.consentInformText}"/> <c:out value="${spkCtrl.consentInformedText}"/>" class="tableTextEmp"/>
    <label for="subscribeInformedConsent" ><ips:pdescr/> <ips:prequired/></label><p class="tableTextEmp"><c:out value="${spkCtrl.consentInformText}"/></p><p class="tableTextEmp"><c:out value="${spkCtrl.consentInformedText}"/></p>
  </div></td><ips:pvalidationresult/></tr>

</ips:pedit>

<ips:pedit name="informedConsentInPaperFormSignedDelegate">
<c:if test="${spkCtrl.selectedProject.informedConsentPaperForm}">
<tr><td><ips:pdescr/></td><td><input type="checkbox" name="informedConsentInPaperFormSignedDelegate"></td><ips:pvalidationresult/></tr>
</c:if>
</ips:pedit>

<ips:pedit name="informedConsentDelegate">
<c:if test="${not spkCtrl.selectedProject.informedConsentPaperForm}">
<tr style="margin: 2em"><td colspan="2"><div>
    <input type="checkbox" id="subscribeInformedConsent" name="informedConsentDelegate" value="<c:out value="${spkCtrl.consentInformText}"/> <c:out value="${spkCtrl.consentInformedText}"/>" class="tableTextEmp"/>
    <label for="subscribeInformedConsent" ><ips:pdescr/> <ips:prequired/></label><p class="tableTextEmp">${spkCtrl.consentInformHtml}</p><p class="tableTextEmp"><c:out value="${spkCtrl.consentInformedText}"/></p>
  </div></td><ips:pvalidationresult/></tr>
  </c:if>
</ips:pedit>

<ips:pedit name="informedBroadConsentDelegate">
<c:if test="${spkCtrl.selectedProject.enableBroadConsent and not spkCtrl.selectedProject.informedConsentPaperForm}">
<tr style="margin: 2em"><td colspan="2"><div>
    <input type="checkbox" id="subscribeInformedBroadConsent" name="informedBroadConsentDelegate" value="<c:out value="${spkCtrl.broadConsentInformedText}"/>" class="tableTextEmp"/>
    <label for="subscribeInformedBroadConsent" ><ips:pdescr/> <ips:prequired/></label><p class="tableTextEmp"><c:out value="${spkCtrl.broadConsentInformedText}"/></p>
  </div></td><ips:pvalidationresult/></tr>
  </c:if>
</ips:pedit>

<ips:pedit name="wouldLikeToBeInformedOfTheStudysFindings">
   <tr style="margin: 2em"><td colspan="2"><div>
   <input type="checkbox" id="wouldLikeToBeInformedOfTheStudysFindingsCb" name="wouldLikeToBeInformedOfTheStudysFindings"<c:if test="${spkCtrl.item.wouldLikeToBeInformedOfTheStudysFindings}"> checked="checked"</c:if>/>
   <label for="wouldLikeToBeInformedOfTheStudysFindingsCb"><fmt:message key="would.like.to.be.informed.of.the.studys.findings.text" bundle="${beans}"/></label>
   </div></td></tr>
</ips:pedit>

<ips:pedit name="wouldLikeToBeContactedForParticipationInFutureStudies">
   <tr style="margin: 2em"><td colspan="2"><div>
   <input type="checkbox" id="wouldLikeToBeContactedForParticipationInFutureStudiesCb" name="wouldLikeToBeContactedForParticipationInFutureStudies"<c:if test="${spkCtrl.item.wouldLikeToBeContactedForParticipationInFutureStudies}"> checked="checked"</c:if>/>
   <label for="wouldLikeToBeContactedForParticipationInFutureStudiesCb"><fmt:message key="would.like.to.be.contacted.for.participation.in.future.studies.text" bundle="${beans}"/></label>
   </div></td></tr>
</ips:pedit>
 
</ips:bform>

<p><fmt:message key="speaker.request.attributes"/></p>
</ips:ctrl_div>
<ips:ctrl_div result="success">
<p>
<fmt:message key="speaker.store.confirm"><fmt:param value="${spkCtrl.item}"/></fmt:message>
</p>
<br>
<c:url value="/session/db/session/SessionNew.jsp" var="sessionNewURL" scope="request">
<c:param name="_cmd" value="new"/>
<c:param name="project.name" value="${spkCtrl.selectedProject.name}"/>
<c:param name="speakers.personId" value="${spkCtrl.item.personId}"/>
<c:param name="type" value="NORM"/>
<c:param name="code" value="${spkCtrl.selectedProject.sessionCode}"/>
</c:url>
<form method="post" action="<c:out value="${sessionNewURL}"/>">
<ips:psecuretoken/>
<input type="submit" name="submit" value="<fmt:message key="session.new.for_speaker"><fmt:param value="${spkCtrl.item}"/></fmt:message> &gt;&gt;"/>
</form>
</ips:ctrl_div>
<ips:ctrl_div result="cancel">
<p><fmt:message key="cancelled"/></p>
</ips:ctrl_div>
</ips:ctrl_process>
</td></tr>
</table>
</body>
</html>
