package ipsk.db.speech.utils;

import ipsk.audio.AudioPluginException;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.arr.Selection;
import ipsk.audio.export.RecordingFileExportConfiguration;
import ipsk.audio.plugins.ChannelSelectorPlugin;
import ipsk.audio.plugins.EditPlugin;
import ipsk.awt.ProgressWorker;
import ipsk.db.speech.RecordingFile;
import ipsk.io.StreamCopy;
import ipsk.persistence.EntityManagerWorker;
//import ipsk.webapps.audio.AudioSystemWrapper;
import ipsk.webapps.audio.RecordingFileHelper;
import ipsk.webapps.audio.RecordingFileHelper.RecordingFileEdit;
import ipsk.webapps.db.speech.ChunkedRecordingStates;
import ipsk.webapps.db.speech.ChunkedRecordingStates.ChunkedRecordingState;
import ipsk.webapps.db.speech.ws.SessionRecfileResource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.AudioFormat.Encoding;

public class RecordingFileExporter extends EntityManagerWorker{
	
	private RecordingFileExportConfiguration configuration;
	private int recordingFileId;
	private File outputDir;
	private AudioFileFormat.Type pcmAudioFileFormatType;
	private DecimalFormat channelNumberFormatter;
	private ipsk.audio.capture.session.info.RecordingFile recordingFileInfo=null;
	
	private String pcmDotExtension;
	
	public RecordingFileExporter(EntityManagerFactory entityManagerFactory,RecordingFileExportConfiguration configuration) {
		super(entityManagerFactory);
		setConfiguration(configuration);
	}
	
	public RecordingFileExporter(EntityManager entityManager,RecordingFileExportConfiguration configuration) {
		super(entityManager);
		setConfiguration(configuration);
	}
	
	

	public void decodeAndEditAudiostream(URL recFileUrl,RecordingFileEdit rfe, AudioFormat.Encoding trgEncoding,File outFile)
			throws IOException, UnsupportedAudioFileException, AudioPluginException {
		AudioInputStream encodedInputStream = null;
		try {
//			encodedInputStream = AudioSystemWrapper
//					.getAudioInputStream(recFileUrl);
			encodedInputStream=ThreadSafeAudioSystem.getAudioInputStream(recFileUrl);
		} catch (UnsupportedAudioFileException e) {
			e.printStackTrace();
			throw e;
		} catch (IOException e) {
			e.printStackTrace();
			throw e;
		}
//		AudioInputStream pcmSignedStream = AudioSystemWrapper
//				.getAudioInputStream(Encoding.PCM_SIGNED, encodedInputStream);
		AudioInputStream pcmSignedStream=null;
		Selection sel=null;
		try{
			pcmSignedStream = ThreadSafeAudioSystem
			.getAudioInputStream(trgEncoding, encodedInputStream);
			AudioFormat af=pcmSignedStream.getFormat();
			float sr=af.getSampleRate();
			sel=rfe.toSelection(sr);
		}catch(IllegalArgumentException iae){
			iae.printStackTrace();
			if(encodedInputStream!=null){
				encodedInputStream.close();
			}
			throw iae;
		}
		AudioInputStream editedPcmSignedStream;
		
		if(sel==null) {
			editedPcmSignedStream=pcmSignedStream;
		}else {
			EditPlugin editplugin=new EditPlugin(sel);
			editedPcmSignedStream=editplugin.getAudioInputStream(pcmSignedStream);
		}
		try {
			ThreadSafeAudioSystem.write(editedPcmSignedStream, pcmAudioFileFormatType, outFile);
		} catch (IOException e) {
			if (pcmSignedStream != null){
				try {
					pcmSignedStream.close();
				} catch (IOException e1) {
					// we throw the first occured exception
				}
			}
			throw e;
		}
		if (pcmSignedStream != null){
			try {
				pcmSignedStream.close();
			} catch (IOException e1) {
				throw e1;
			}
		}
	}

	
	public void doWork() throws ExportException {

		recordingFileInfo=null;
		
		// create dir if necessary
		if (outputDir == null) {
			throw new ExportException("No output directory or stream given!");
		}

		if (!outputDir.exists()) {
			boolean created = outputDir.mkdirs();
			if (created) {
				throw new ExportException("Output directory already exists!");
			}
		}
		RecordingFile recordingFile=entityManager.find(RecordingFile.class,recordingFileId);
		RecordingFile.Status rfSt=recordingFile.getStatus();
		if(rfSt!=null && !RecordingFile.Status.REGISTERED.equals(rfSt)) {
			ReentrantLock lock=null;
			if(RecordingFile.Status.PARTIALLY_RECORDED.equals(rfSt)) {
				String rfUuidStr=recordingFile.getUuid();
				if(rfUuidStr!=null) {
					UUID rfUUID=UUID.fromString(rfUuidStr);
					synchronized (ChunkedRecordingStates.recordingFileLocks) {
						ChunkedRecordingState crs=ChunkedRecordingStates.recordingFileLocks.get(rfUUID);
						if(crs!=null) {
							lock=crs.getReentrantLock();
						}
					}
				}
			}
			if(lock!=null) {
				lock.lock();
			}
			
			RecordingFileEdit rfe=new RecordingFileEdit(recordingFile);
			String signalFileUrlStr = recordingFile.getSignalFile();

			//Selection sel=null;
			URL recFileUrl = null;

			try {
				recFileUrl = new URL(signalFileUrlStr);
			} catch (MalformedURLException e) {
				e.printStackTrace();
				throw new ExportException(e);
			}
			if (recFileUrl != null) {

				File pcmConvertedFile = null;
				File tempPcmConvertedFile=null;
				try{
					String rfEncoding=recordingFile.getEncoding();
					String pcmSignedStr=AudioFormat.Encoding.PCM_SIGNED.toString();
					String pcmFloatStr=AudioFormat.Encoding.PCM_FLOAT.toString();
					Encoding trgEncoding=Encoding.PCM_SIGNED;
					boolean isPCMSigned = pcmSignedStr.equalsIgnoreCase(rfEncoding);
					
					boolean isPCMFloat = pcmFloatStr.equalsIgnoreCase(rfEncoding);
					if(isPCMFloat) {
						trgEncoding=Encoding.PCM_FLOAT;
					}
					// Float is signed as well
					boolean isPCMSignedOrFloat=isPCMSigned || isPCMFloat; 
					String path = recFileUrl.getPath();
					String fileName = path.substring(path.lastIndexOf("/") + 1);
					int dotIndex = fileName.lastIndexOf(".");
					String fileNameBody = fileName.substring(0, dotIndex);
					if (
							configuration.isIncludeOriginalRecordingFiles()
							|| (configuration.isIncludePCMConvertedFiles() && isPCMSignedOrFloat && rfe.isEdit())
							) {

						// copy original audio file (compressed or PCM)
						InputStream recFileStream;
						File outFile = new File(outputDir, fileName);
						try {
							recFileStream = recFileUrl.openStream();
							StreamCopy.copy(recFileStream, outFile, false);

						} catch (IOException e) {
							e.printStackTrace();
							throw new ExportException(e);
						}

						if(isPCMSignedOrFloat){
							// already PCM
							pcmConvertedFile=outFile;
						}

					}
					if (configuration.isIncludePCMConvertedFiles() && !isPCMSignedOrFloat) {

						String outFileName = fileNameBody.concat(pcmDotExtension);

						pcmConvertedFile = new File(outputDir, outFileName);
						try {
							decodeAndEditAudiostream(recFileUrl,rfe, trgEncoding,pcmConvertedFile);

						} catch (IOException | UnsupportedAudioFileException | AudioPluginException e) {
							e.printStackTrace();
							throw new ExportException(e);
						}

					}
					if (configuration.isIncludePCMPickedChannelFiles()) {
						// create splitted mono channel audio files 

						// make sure to have a PCM decoded file
						if (pcmConvertedFile == null) {
							try {
								String outFileName = fileNameBody.concat(pcmDotExtension);
								tempPcmConvertedFile =new File(outputDir, outFileName);
								decodeAndEditAudiostream(recFileUrl, rfe, trgEncoding,tempPcmConvertedFile);
								pcmConvertedFile=tempPcmConvertedFile;
							} catch (IOException | UnsupportedAudioFileException | AudioPluginException e) {

								throw new ExportException(e);
							}
						}
						AudioFileFormat aff;
						try {
							aff = ThreadSafeAudioSystem.getAudioFileFormat(pcmConvertedFile);
						} catch (UnsupportedAudioFileException e) {
							e.printStackTrace();
							throw new ExportException(e);
						} catch (IOException e) {
							e.printStackTrace();
							throw new ExportException(e);
						}
						AudioFormat af = aff.getFormat();
						int rfChannels = af.getChannels();

						if(rfChannels==1){
							// already converted, mark as non temporary 
							tempPcmConvertedFile=null;

						}else if (rfChannels > 1 ) {
							// split if more than one channel
							int[] pChannels;
							int[] pickedChannels = configuration.getPickedChannels();
							if (pickedChannels != null) {
								pChannels = pickedChannels;
							} else {
								// default: all channels
								pChannels = new int[rfChannels];
								for (int i = 0; i < rfChannels; i++) {
									pChannels[i] = i;
								}
							}
							// split
							for (int i = 0; i < pChannels.length; i++) {
								int selCh = pChannels[i];
								if (selCh > rfChannels) {
									throw new ExportException(
											"Cannot pick audio channel " + selCh
											+ " of " + pcmConvertedFile
											+ ". Audio stream has only "
											+ rfChannels + "!");
								}
								String pickedChannelFileName = fileNameBody + "_"
										+ channelNumberFormatter.format(selCh)
										+ pcmDotExtension;
								File pickedChannelFile = new File(outputDir,
										pickedChannelFileName);
								ChannelSelectorPlugin chSel = new ChannelSelectorPlugin(
										selCh);
								AudioInputStream pcmOrgStream=null;
								//						try {
								try {
									pcmOrgStream = ThreadSafeAudioSystem
											.getAudioInputStream(pcmConvertedFile);
								} catch (UnsupportedAudioFileException e) {
									throw new ExportException(e);
								} catch (IOException e) {
									throw new ExportException(e);
								}

								AudioInputStream pickedChannelStream;
								try {
									pickedChannelStream = chSel
											.getAudioInputStream(pcmOrgStream);
								} catch (AudioPluginException e) {
									e.printStackTrace();
									if(pcmOrgStream!=null){
										try {
											pcmOrgStream.close();
										} catch (IOException e1) {
											// already throwing an exception 
										}
									}
									throw new ExportException(e);
								}
								try {
									ThreadSafeAudioSystem.write(pickedChannelStream,
											pcmAudioFileFormatType, pickedChannelFile);
								} catch (Exception e) {
									if(pickedChannelStream!=null){
										try {
											pickedChannelStream.close();
										} catch (IOException ioe) {
											// we throw the first exception 
										}
									}
									throw new ExportException(e);
								}
								if(pickedChannelStream!=null){
									try {
										pickedChannelStream.close();
									} catch (IOException e) {
										throw new ExportException(e);
									}
								}
							}
						}
					}
					if(pcmConvertedFile!=null) {
						recordingFileInfo=new ipsk.audio.capture.session.info.RecordingFile();
						recordingFileInfo.setFile(new File(pcmConvertedFile.getName()));
					}

				}catch(ExportException e){
					throw e;
				}finally{
					if(tempPcmConvertedFile!=null){
						//					tempPcmConvertedFile.deleteOnExit();
						tempPcmConvertedFile.delete();
					}
				}
			}
			if(lock!=null) {
				lock.unlock();
			}
			
		}
	}



	public ipsk.audio.capture.session.info.RecordingFile getRecordingFileInfo() {
		return recordingFileInfo;
	}

	public RecordingFileExportConfiguration getConfiguration() {
		return configuration;
	}



	public void setConfiguration(RecordingFileExportConfiguration configuration) {
		this.configuration = configuration;
		pcmAudioFileFormatType = configuration.getPcmAudioFileFormatType();
		channelNumberFormatter = new DecimalFormat(configuration
				.getChannelNumberFormat());
		pcmDotExtension = "." + pcmAudioFileFormatType.getExtension();
	}




	public File getOutputDir() {
		return outputDir;
	}



	public void setOutputDir(File outputDir) {
		this.outputDir = outputDir;
	}

	public int getRecordingFileId() {
		return recordingFileId;
	}

	public void setRecordingFileId(int recordingFileId) {
		this.recordingFileId = recordingFileId;
	}



}
