package ipsk.webapps.db.speech.ws;

import java.io.IOException;

import javax.ws.rs.ForbiddenException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;

public class CSRFProtectionFilter implements ContainerRequestFilter{

	private static String[] PASS_METHODS= {"GET","HEAD","OPTIONS"};
	 public static final String[] PASS_EXISTING_HEADER_NAMES = {"X-Requested-By","X-Requested-With"};
	@Override
	public void filter(ContainerRequestContext requestContext) throws IOException {
		String method=requestContext.getMethod();
		for(String passMethod:PASS_METHODS) {
			if(passMethod.equalsIgnoreCase(method)) {
				return;
			}
		}
		
		for(String passExHNm:PASS_EXISTING_HEADER_NAMES) {
			if(requestContext.getHeaders().containsKey(passExHNm)){
				// this header cannot exist for an CSRF attck request
				// it is sufficient if it exists
				return;
			}
		}
		
		throw new ForbiddenException();
	}
	

}
