package ipsk.webapps.db.speech.ws.pub;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.ResponseBuilder;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;

import ipsk.audio.AudioPluginException;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.arr.Selection;
import ipsk.audio.plugins.EditPlugin;
import ipsk.db.speech.Account;
import ipsk.db.speech.Project;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.RecordingTrack;
import ipsk.db.speech.Session;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.Script;
import ipsk.io.StreamCopy;
import ipsk.io.VectorBufferedInputStream;
import ipsk.io.VectorBufferedOutputStream;
import ipsk.net.Utils;
import ipsk.persistence.EntityManagerProvider;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.PermissionDeniedException;
import ipsk.webapps.audio.DSPProcessor;
import ipsk.webapps.audio.RecordingFileHelper;
import ipsk.webapps.audio.RecordingFileHelper.RecordingFileEdit;
import ipsk.webapps.db.speech.RecordingFileController;
import ipsk.webapps.db.speech.SessionController;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;

@Path("/pseudonymized/recfile")
public class PseudonymizedPublicRecordingfileResource {


	private final static boolean DEBUG = true;

	private static final long serialVersionUID = 1L;

	private String sessionIdStr = null;

	private File tempDir = null;

	protected final static int DEFAULT_BUFSIZE = 2048;

	protected int bufSize = DEFAULT_BUFSIZE;
	
	private CacheControl cacheControl;

	// TODO build a generic and a WikiSpeech specific service class

	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public PseudonymizedPublicRecordingfileResource() {
		super();
		tempDir = new File(System.getProperty("java.io.tmpdir"));
		cacheControl=new CacheControl();
		// keep the files out of persistent caches
		cacheControl.setPrivate(true);
		cacheControl.setNoCache(true);
		cacheControl.setNoStore(true);
	}

	public PseudonymizedPublicRecordingfileResource(String sessionIdStr) {
		this();
		this.sessionIdStr = sessionIdStr;

	}
	

//	private Response streamRecFile(RecordingFile rf,ServletContext sc){
//
//		String fileURLStr = rf.getSignalFile().trim();
//
//		try {
//			URL orgFileURL = new URL(fileURLStr);
//			InputStream rfeStream;
//			Selection s=RecordingFileHelper.selectionFromRecordingFileDescr(rf);
//			final java.nio.file.Path tmpEditedAudioFile;
//			if(s==null) {
//				sc.log("Stream original recording file ID "+rf.getRecordingFileId());
//				rfeStream = orgFileURL.openStream();
//				tmpEditedAudioFile=null;
//			}else {
//				sc.log("Stream recording file ID "+rf.getRecordingFileId()+" with edit selection: "+s);
//				AudioInputStream orgAs=AudioSystem.getAudioInputStream(orgFileURL);
//				EditPlugin ep=new EditPlugin(s);
//				AudioInputStream eAis=ep.getAudioInputStream(orgAs);
//				// Files may be large. Use a temporary file instead of memory here.
//				tmpEditedAudioFile=Files.createTempFile(getClass().getName(),".wav");
//				AudioSystem.write(eAis, AudioFileFormat.Type.WAVE,tmpEditedAudioFile.toFile());
//				rfeStream=new FileInputStream(tmpEditedAudioFile.toFile());
//			}
//				
//			StreamingOutput streamOutput = new StreamingOutput() {
//
//				@Override
//				public void write(OutputStream outputStream)
//						throws IOException, WebApplicationException {
//					StreamCopy.copy(rfeStream, outputStream);
//					if(tmpEditedAudioFile!=null) {
//						try {	
//							Files.delete(tmpEditedAudioFile);
//						}catch (IOException de) {		
//							tmpEditedAudioFile.toFile().deleteOnExit();
//						}
//					}
//				}
//			};
//			return Response.ok(streamOutput).build();
//
//		} catch (UnsupportedAudioFileException | AudioPluginException |IOException e) {
//			sc.log("Failed to stream recording file ID "+rf.getRecordingFileId() ,e);
//			return Response.serverError().build();
//		}
//
//	}



	@GET
	@Path("/{uuid}.wav")	
	@Produces("audio/wav")
	public Response getRecFile(@Context ServletContext sc,@PathParam("uuid") String reqUuidStr) {
		UUID reqUuid=null;
		try {
			reqUuid=UUID.fromString(reqUuidStr);
		}catch(IllegalArgumentException iae) {
			return Response.status(Status.BAD_REQUEST).build();
		}
		
		final EntityManager em = EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		
		try {
			String reqUuidLc=reqUuid.toString().toLowerCase();
			CriteriaBuilder cb = em.getCriteriaBuilder();
			CriteriaQuery<RecordingFile> cq = cb.createQuery(RecordingFile.class);
			Root<RecordingFile> qrf = cq.from(RecordingFile.class);
			cq.select(qrf);
			Expression<String> uuidLc=cb.lower(qrf.<String>get("uuid"));
			Predicate uuidEqualsCaseInsensitive=cb.equal(uuidLc,reqUuidLc );
			cq.where(uuidEqualsCaseInsensitive);
			TypedQuery<RecordingFile> rfq = em.createQuery(cq);
			List<RecordingFile> resultList = rfq.getResultList();
			int rfListSize=resultList.size();
			if(rfListSize==0) {
				return Response.status(Status.NOT_FOUND).build();
			}else if(rfListSize>1) {
				// multiple results -> Error
				return Response.status(Status.INTERNAL_SERVER_ERROR).build();
			}else if(rfListSize==1){
				RecordingFile rf=resultList.get(0);

				// check id export allowed
				Session session = rf.getSession();
				if (session != null) {	
					Project prj=session.getProject();

					if(prj!=null) {
						if(!prj.isAllowPublicPseudonymizedAudioExport() || !session.isExportForAnnotation()) {
							return Response.status(Status.FORBIDDEN).build();
						}

						//return streamRecFile(rf);
						
						String fileURLStr = rf.getSignalFile().trim();
						URL fileURL = new URL(fileURLStr);
						
						File recFile=Utils.fileFromDecodedURL(fileURL);
						
						WavFileEntity wfe;
						RecordingFileEdit rfe=new RecordingFileEdit(rf);
						
						final java.nio.file.Path tmpEditedAudioFile;
						if(!rfe.isEdit()) {
							sc.log("Send original recording file ID "+rf.getRecordingFileId());
							wfe=new WavFileEntity(recFile.toPath());
						}else {			
							AudioInputStream orgAs=AudioSystem.getAudioInputStream(recFile);
							AudioFormat af=orgAs.getFormat();
							float sr=af.getSampleRate();
							Selection s=rfe.toSelection(sr);
							sc.log("Send recording file ID "+rf.getRecordingFileId()+" with edit selection: "+s);
							EditPlugin ep=new EditPlugin(s);
							AudioInputStream eAis=ep.getAudioInputStream(orgAs);
							// Files may be large. Use a temporary file instead of memory here.
							tmpEditedAudioFile=Files.createTempFile(getClass().getName(),".wav");
							AudioSystem.write(eAis, AudioFileFormat.Type.WAVE,tmpEditedAudioFile.toFile());
							wfe=new WavFileEntity(tmpEditedAudioFile, true);
						}
						
						ResponseBuilder rb=Response.ok(wfe,"audio/wav");
						rb.header("X-Robots-Tag","none");
						rb.cacheControl(cacheControl);
						
						return rb.build();

					}
				}
			}
		}catch(Exception e) {
			return Response.status(Status.INTERNAL_SERVER_ERROR).build();
		} finally {
			em.close();
		}
		return Response.status(Status.INTERNAL_SERVER_ERROR).build();
	}

}
