/*
 * Created on May 30, 2005
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package ipsk.webapps.db.servlets;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.ParserConfigurationException;

import org.eclipse.persistence.jaxb.JAXBContextProperties;
import org.w3c.dom.Document;

import ipsk.apps.speechrecorder.script.RecscriptHandler;
import ipsk.apps.speechrecorder.script.RecscriptHandlerException;
import ipsk.db.speech.Session;
import ipsk.db.speech.script.Script;
import ipsk.net.MIMEType;
import ipsk.net.MIMEUtils;
import ipsk.text.ParserException;
import ipsk.webapps.ControllerException;
import ipsk.webapps.PermissionDeniedException;
import ipsk.webapps.db.speech.SessionController;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;
import ipsk.webapps.db.speech.script.ScriptController;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;

/**
 * Servlet sends SpeechRecorder recording script from Speech DB to client.
 * @author klausj
 * 
 */
public class ScriptServlet extends HttpServlet {

	public static final String NAME = "session";

	public static final String SYSTEM_ID = "SpeechRecPrompts_2.dtd";
	private volatile JAXBContext jaxbContext;
	private HashMap jaxbEclipseLinkPropsmap;
	private static volatile Charset cs;
	private static String CS_NAME = "UTF-8";
	
	private WikiSpeechSecurityManager securityManager;

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public void init() throws ServletException{
		super.init();
		jaxbEclipseLinkPropsmap = new HashMap();
		jaxbEclipseLinkPropsmap.put("javax.xml.bind.context.factory",
				"org.eclipse.persistence.jaxb.JAXBContextFactory");
		//	jaxbEclipseLinkPropsmap.put(JAXBContextFactory.ECLIPSELINK_OXM_XML_KEY, "ipsk/db/speech/moxy_binding_overwrites.xml");
		jaxbEclipseLinkPropsmap.put(JAXBContextProperties.OXM_METADATA_SOURCE, "ipsk/db/speech/moxy_binding_wikispeech_client_overwrites.xml");
		
	}
	
	private synchronized JAXBContext jaxbContext() throws JAXBException {
		if (jaxbContext == null) {
			cs = Charset.forName(CS_NAME);
			
			// JAXBContext jc = JAXBContext.newInstance(Bundle.class);
			jaxbContext = org.eclipse.persistence.jaxb.JAXBContextFactory.createContext(new Class[] { Script.class },
					jaxbEclipseLinkPropsmap);

		}
		return jaxbContext;
	}
	
	protected void doGet(HttpServletRequest req, HttpServletResponse res)
			throws ServletException, IOException {
		String user = req.getRemoteUser();
		log("Script servlet (GET) started for user " + user + "...");

		sendScript(req, res);
		
	}

	protected void doPost(HttpServletRequest req, HttpServletResponse res)
			throws ServletException, IOException {
		String user = req.getRemoteUser();
		log("Script servlet (POST) started for user " + user + "...");

		sendScript(req, res);
		
	}
	
	
	

	private void sendScript(HttpServletRequest req, HttpServletResponse res)
	throws ServletException,IOException {
		//String reqURL = new String(req.getRequestURL());
		Script script = null;
		List<MIMEType> reqMimes = null;
		String accHeader = req.getHeader("Accept");
		res.setCharacterEncoding("UTF-8");
		MIMEType reqAccType = null;
		if (accHeader == null) {
			// default XML
			reqAccType = MIMEType.TEXT_XML;
		} else {
			try {
				reqMimes = MIMEUtils.parseMediaRange(accHeader);
			} catch (ParserException e) {
				log(e.getMessage());
				res.sendError(500, "Error parsing accept header.");
			}
		}
		if (reqAccType == null) {
			// check Accept header for matching MIMEs
			MIMEType[] suppMts = new MIMEType[] {MIMEType.TEXT_XML,MIMEType.APPLICATION_XML, MIMEType.APPLICATION_JSON};
			reqAccType = MIMEUtils.preferredMimeType(Arrays.asList(suppMts), reqMimes);
		}
		if(reqAccType==null){
			res.sendError(406, "Unsupported MIME type");
		}
		
		res.setContentType(reqAccType.toString());
		
		Session s =null;
		SessionController sessCtrl=null;
		HttpSession hs=req.getSession();
		if(hs!=null){
			Object sessCtrlObj=hs.getAttribute("sessCtrl");
			if(sessCtrlObj instanceof SessionController){
				sessCtrl=(SessionController)sessCtrlObj;
				sessCtrl.open();
				try {
					s = sessCtrl.getSession();
				} catch (ControllerException e) {
					e.printStackTrace();
					log("Cannot get session id from controller: "+e.getMessage());
					throw new IOException(e);
					
				}
				if(s!=null){
					log("Using session ID from controller...");
				}
			}
		}
		if(sessCtrl==null){
			sessCtrl= new SessionController();
			sessCtrl.open();
		}
		
		ScriptController scriptCtrl = new ScriptController();
		scriptCtrl.open();
		try {
			
			String scriptIdStr = req.getParameter("scriptId");
			if(scriptIdStr==null){
				scriptIdStr = req.getParameter("script_id");
			}
			if (scriptIdStr != null) {
				log("Getting script by script ID...");
				script = scriptCtrl.getScriptById(Integer.parseInt(scriptIdStr));
				log("Cannot find recording script with ID " + scriptIdStr);
			}
			if(script==null) {

				if(s==null){
					String sessionIdStr = req.getParameter("sessionId");
					if(sessionIdStr==null){
						sessionIdStr = req.getParameter("session_id");
					}

					if (sessionIdStr != null) {
						log("getting script by session ID...");
						int sessionId = Integer.parseInt(sessionIdStr);
						s = sessCtrl.getById(sessionId);
						sessCtrl.getSecurityManager().checkReadPermission(req,s );
					}

				}
				if(s!=null){
					int sessionId=s.getSessionId();
					if (Session.Type.SINE_TEST.equals(s.getType())) {
						log(s + " is Sine-Test");
						//script = scriptCtrl.getSinusTestScript();
						script=sessCtrl.setSinusTestScriptForSession(sessionId);
					} else {
						//script = sessCtrl.setScriptWithLowestUsageForSession(sessionId);
						RecscriptHandler rsh=new RecscriptHandler();
						rsh.setValidating(true);
						List<Script> scriptsSortedByLowestUsage=scriptCtrl.scriptsSortedByLowestUsage(sessionId);
						for(Script pscr:scriptsSortedByLowestUsage){
							String validMsg=rsh.scriptValid(pscr);
							int pScriptId=pscr.getScriptId();
							if(validMsg!=null){
								log("Recording script ID "+pScriptId+" validation error: "+validMsg);
							}else{
								// valid script found
								// set for session
								log("Setting script ID "+pScriptId+" for session ID: "+sessionId);
								sessCtrl.setScriptForSession(sessionId,pScriptId);
								script=pscr;
								break;
							}
						}
					}
					if (script == null) {
						log("Warning: Cannot associate a recording script for session" + s);
						log("Warning: Is at least one script defined for the project?");
					}
				}
			}
			if (script == null) {		
				throw new ControllerException("Cannot get recording script !");
			}else {
				scriptCtrl.getSecurityManager().checkReadPermission(req,script);
			}
			
			if (MIMEType.APPLICATION_JSON.equals(reqAccType)) {
				Marshaller marshaller;
				try {

					JAXBContext jc = jaxbContext();
					marshaller = jc.createMarshaller();

					marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
					marshaller.setProperty("eclipselink.media-type", "application/json");
					marshaller.marshal(script, res.getWriter());
					// unmarshaller.setProperty("eclipselink.json.include-root",
					// false);
				} catch (JAXBException e) {
					throw new ServletException(e);
				}
			}else if(MIMEType.TEXT_XML.equals(reqAccType) || MIMEType.APPLICATION_XML.equals(reqAccType)){

				DOMConverter conv = new DOMConverter();
				Document d = scriptCtrl.toDOM(script);

				//			StringWriter sw=new StringWriter();
				//			conv.writeXML(d, null, RecscriptHandler.REC_SCRIPT_DTD,sw );
				//			log(sw.toString());

				conv.writeXML(d, null, RecscriptHandler.REC_SCRIPT_DTD, res.getWriter());
				sessCtrl.commit();
				scriptCtrl.commit();

			}else{
				throw new ServletException("Unknown MIME type");
			}
			log("Sent script ID "+script.getScriptId()+" as "+reqAccType);
		} catch (ParserConfigurationException e) {
			throw new IOException("Could not convert Script to DOM: \n"
					+ e.getMessage());
		} catch (DOMConverterException e) {
			throw new IOException("Could not convert DOM to XML: \n"
					+ e.getMessage());
		}catch (PermissionDeniedException e) {
			log(e.getMessage(), e);
			res.sendError(HttpServletResponse.SC_FORBIDDEN, "Permission denied!");
			return;
		}  catch (ControllerException e) {
			e.printStackTrace();
			throw new IOException(e.getMessage());
		} catch (IOException e) {
			e.printStackTrace();
			throw e;
		} catch (RecscriptHandlerException e) {
			throw new IOException("Could not convert Script to XML: \n"
					+ e.getMessage());
		} finally {
			scriptCtrl.close();
			sessCtrl.close();
		}
		
		

	}

}
