package ipsk.webapps.db.speech;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;


public class ChunkedRecordingStates {

	public static Map<UUID,ChunkedRecordingState> recordingFileLocks=new HashMap<>();
	
	public static class ChunkedRecordingState{
		
		private Date startedDate;
		
		public Date getStartedDate() {
			return startedDate;
		}
		public void setStartedDate(Date startedDate) {
			this.startedDate = startedDate;
		}
		private ReentrantLock reentrantLock=new ReentrantLock();
		public ReentrantLock getReentrantLock() {
			return reentrantLock;
		}
		private List<Integer> storedChunks=new ArrayList<>();
		public int size() {
			return storedChunks.size();
		}
		public boolean addChunkIndex(Integer e) {
			return storedChunks.add(e);
		}
		public Integer getChunkIndex(int index) {
			return storedChunks.get(index);
		}
		
		public int availableSequencedChunks() {
			int asi=0;
			while(storedChunks.contains(asi)) {
				asi++;
			}
			return asi;
		}
		
		private int concatenatedChunkCount=0;
		
		public void setConcatenatedChunkCount(int concatenatedChunkCount) {
			this.concatenatedChunkCount = concatenatedChunkCount;
		}
		public int getConcatenatedChunkCount() {
			return concatenatedChunkCount;
		}
		
		private Integer finalChunkCount=null;
		
		public Integer getFinalChunkCount() {
			return finalChunkCount;
		}
		
		public void finalChunkCount(int finalChunkCount) {
			this.finalChunkCount=finalChunkCount;
		}

		private boolean complete=false;
		public boolean isComplete() {
			return complete;
		}
		
		public void complete() {
			complete=true;
		}
		
	}
	

}
