package ipsk.webapps.db.speech.project;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ips.beans.PersistenceMapConverter;
import ipsk.beans.MapConverterException;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.validation.ValidationException;
import ipsk.beans.validation.ValidationResult;
import ipsk.db.speech.Account;
import ipsk.db.speech.LocalizedMessage;
import ipsk.db.speech.Project;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.project.AutoGainControlConfig;
import ipsk.db.speech.project.LocalizedDefaultPurposeText;
import ipsk.db.speech.project.LocalizedInformedConsentText;
import ipsk.db.speech.project.MediaStreamConstraints;
import ipsk.db.speech.script.Script;
import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.persistence.QueryParam;
import ipsk.text.StringSequenceBuilder;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.ControllerException;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.db.speech.BasicProjectAdminController;
import ipsk.webapps.db.speech.BasicWikiSpeechController;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;

public class AutoGainControlConfigController extends BasicProjectAdminController<AutoGainControlConfig> {
	
	public AutoGainControlConfigController() {
		super("WebSpeechDBPU",AutoGainControlConfig.class, "agc_config");
	}
	
	public void projectsAutoGainControlConfigs(HttpServletRequest req) throws ControllerException {
		Account acc = getAccountByRequest(req);
		
		createEmptyBeanTableModel(req);
		
		if (acc != null && req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())) {
			applyOwningProject(req);
			ParameterizedQuery pq = new ParameterizedQuery(queryType);

			String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;

			pq.setWhereClause(jse +".project = :owningProject");
			pq.setQueryParams(new QueryParam[] {new QueryParam("owningProject", owningProject)});
			super.processRequest(req,pq);
		}
	}
	
	public ValidationResult validate(Object o,ValidationResult validationResult) throws ValidationException{
		ValidationResult vr=super.validate(o, validationResult);
		return vr;
	}
	
}
