package ipsk.webapps.db.speech.ws;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.eclipse.persistence.internal.libraries.asm.commons.GeneratorAdapter;

import ipsk.db.speech.Account;
import ipsk.db.speech.Person;
import ipsk.db.speech.Project;
import ipsk.db.speech.Session;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.UserRoleId;
import ipsk.persistence.EntityManagerProvider;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.PermissionDeniedException;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;


public class ProjectSpeakerResource extends WikispeechBasicResource<Speaker>{

	private String projectName;

	public ProjectSpeakerResource(String projectName) {
		super(Speaker.class);
		this.projectName = projectName;
	}

	
	@GET
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
	@Path("/{speakerIdOrUUID}")
	public Response getSpeaker(@Context HttpServletRequest req, @PathParam("speakerIdOrUUID") String speakerId) {
		return get(req, speakerId);
	}


	
	
	private Response projectSpeakers(HttpServletRequest req,boolean content) {
		final EntityManager em = EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		WikiSpeechSecurityManager securityManager = new WikiSpeechSecurityManager(new EntityManagerProvider() {
			@Override
			public EntityManager getThreadEntityManager() {
				return em;
			}
		});
		try {

			Set<Speaker> projSpks=new HashSet<Speaker>();
			Project p=em.find(Project.class, this.projectName);
			
			Account acc=getAccountByRequest(req, em);
		
			// Add self
			Person accPers=acc.getPerson();
			if(accPers instanceof Speaker){
				Speaker accSpk=(Speaker)accPers;
				projSpks.add(accSpk);
			}
			
			Set<Speaker> accSpkDatas=acc.getSpeakerData();
			for(Speaker spkData:accSpkDatas) {
				projSpks.add(spkData);
			}
			
			// Add speakers registered by this account
			projSpks.addAll(acc.getRegisteredSpeakers());
			
			
			
			if(req.isUserInRole(UserRoleId.RoleName.ADMIN.name()) || 
			    (req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name()) && p.getAdminAccounts().contains(acc)))
			{


				// TODO as criteria query ?

				//			CriteriaBuilder cb = em.getCriteriaBuilder();
				//			CriteriaQuery<Speaker> cq = cb.createQuery(Speaker.class);
				//			Root<Speaker> rt = cq.from(Speaker.class);
				//			cq.select(rt);
				//			Subquery<Session> sessQ=cq.subquery(Session.class);
				//			Root<Session> rtSess=sessQ.from(Session.class);
				//			sessQ.where(arg0)
				//			cq.where(cb.exists(sessQ));
				//			Expression<Collection<Session>> sessions = rt.get("sessions");
				//			Expression<Collection<Project>> projects = sess.get("projects");
				//			cq.where(cb.isMember(p, projects));
				//			
				//			
				//			cb.exists(arg0)
				//			Expression<Integer> sessSizeExpr=cb.size(sessions);
				//			
				//			
				//			
				//			TypedQuery<Script> q = em.createQuery(cq);

					
					
					Set<Session> projSesss=p.getSessions();
					for(Session projSess:projSesss){
						Set<Speaker> sessSpks=projSess.getSpeakers();
					
						projSpks.addAll(sessSpks);
					}
					
				
			}
			
			if (content) {
				final GenericEntity<Set<Speaker>> listEntity = new GenericEntity<Set<Speaker>>(projSpks) {};
				return Response.ok(listEntity).header("X-Total-Count", projSpks.size()).build();
			} else {
				return Response.noContent().header("X-Total-Count", projSpks.size()).build();
			}
		} finally {
			em.close();
		}
	}
	
	
	

	@GET
	@Produces({ MediaType.APPLICATION_JSON })
	@Path("/")
	public Response getProjectSpeakers(@Context HttpServletRequest req) {
		return projectSpeakers(req,true);
	}

	@HEAD
	@Produces({ MediaType.APPLICATION_JSON })
	@Path("/")
	public Response headProjectSpeakers(@Context HttpServletRequest req) {
		return projectSpeakers(req,false);
	}

}
