<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"  %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" scope="request"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="session.delete"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="session.delete"/></h2>		 
 
<jsp:useBean id="sessionViewCtrl" scope="request" class="ipsk.webapps.db.speech.SessionController" />
<ips:ctrl_process controller="${sessionViewCtrl}">
<ips:ctrl_div>

<c:set var="fileList" value="${sessionViewCtrl.fileList}"/>
<c:if test="${not empty fileList}">
<p><span style="color:red"><fmt:message key="session.delete.associated_files"/></span></p>
<ul>
<c:forEach items="${fileList}" var="file">
<li><c:out value="${file}"/></li>
</c:forEach>
</ul>
</c:if>
<ips:bview bean="${sessionViewCtrl.item}" action="/db/session/SessionDelete" actionCommand="delete" props="*" tableClass="db">
<ips:pview name="speakers" var="spks">
<tr><td><ips:pdescr/></td><td>
<c:if test="${not empty spks}">
<table>
 <tr><th><span style="color:red"><fmt:message key="delete"/></span></th><th><fmt:message key="id"/></th><th><fmt:message key="speaker"/></th></tr>
<c:forEach items="${spks}" var="spk">

<c:if test="${fn:length(spk.sessions) == 1}">
<!-- Force deleting the speaker if this is the only session the speaker is involved and if the speaker has no associated account -->
 <tr><td>
	  <input type="checkbox" name="_dummy_rel.speakers.personId" disabled readonly value="<c:out value="${spk.personId}"/>"<c:if test="${empty spk.account}"> checked="checked"</c:if>/>
	  <c:if test="${empty spk.account}"><input type="hidden" name="_delete_rel.speakers.personId" value="<c:out value="${spk.personId}"/>" /></c:if></td><td><c:out value="${spk.personId}"/></td><td><c:out value="${spk}"/>
 </td></tr>
</c:if>
<c:if test="${fn:length(spk.sessions) >= 2}">
<!-- Disable speaker deletion if the speaker is involved in other sessions-->
<tr><td><input type="checkbox" name="_dummy.speakers.personId" disabled="disabled" readonly="readonly" value="<c:out value="${spk.personId}"/>"/></td><td><c:out value="${spk.personId}"/></td><td><c:out value="${spk}"/></td></tr>
</c:if>

</c:forEach>
</table>
</c:if>
<c:if test="${empty spks}">#0</c:if>
</td></tr>
</ips:pview>
<ips:pview name="recordingFiles" var="rfs">
<tr><td><ips:pdescr/></td>
    <c:if test="${fn:length(rfs) >0  }"><td><span style="color:red">#<c:out value="${fn:length(rfs)}"/> <fmt:message key="delete.will_be"/></span></td></c:if>
    <c:if test="${fn:length(rfs) ==0  }"><td><fmt:message key="none"/></td></c:if>
</tr>
</ips:pview>
</ips:bview>
<p class="warn"><fmt:message key="deletion.cannot.be.undone"/></p>
</ips:ctrl_div>
<ips:ctrl_div result="success">
<fmt:message key="session.delete.confirm"><fmt:param value="${sessionViewCtrl.item.sessionId}"/></fmt:message>
</ips:ctrl_div>
<ips:ctrl_div result="cancel">
<fmt:message key="cancelled"/>
</ips:ctrl_div>
</ips:ctrl_process>
</td></tr>
</table>
</body>
</html>
