<!DOCTYPE HTML>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true"  errorPage="/errorPage.jsp"%>
<fmt:setBundle basename="Messages" scope="request"/>
<%@page import="ipsk.webapps.db.speech.ProjectController" %>
<html>
<head>
<meta charset="UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title>Datenschutzerkl&auml;rung</title>
</head>
<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
<h1>Datenschutzerkl&auml;rung</h1>
<h2>Anwendungsbereich</h2>
<p>Diese Datenschutzerkl&auml;rung gilt f&uuml;r die Web-Applikation WikiSpeech mit der Basis-URL https://webapp.phonetik.uni-muenchen.de/wikispeech</p>
<h2>Verantwortliche und Kontaktinformationen</h2>
<p>Verantwortlicher im Sinne des Datenschutzes ist:</p>
<p>Christoph Draxler, E-Mail: <a href="mailto:draxler@phonetik.uni-muenchen.de">draxler@phonetik.uni-muenchen.de</a></p>

<p>Anschrift:</p>
<p>Institut f&uuml;r Phonetik und Sprachverarbeitung, LMU M&uuml;nchen<br/>
Schellingstr. 3<br/>
80799 M&uuml;nchen</p>
<p>Die Kontaktdaten des behördlichen Datenschutzbeauftragten der LMU finden Sie im Internet auf der Internetseite der LMU unter <a href="https://www.lmu.de/datenschutz">https://www.lmu.de/datenschutz</a>.</p>


<h2>Besuch der WikiSpeech-Webseiten</h2>
<h3>Personenbezogene Daten, die von uns erfasst werden</h3>
<h4>Zugriffsdaten</h4>
<p>Zu jedem Aufruf einer Resource (Webseite, Bilder, etc.) werden von unserem Server folgende Daten im Server-Log gespeichert:</p>
<ul>
<li>Ihre Internet-Protokoll (IP) Adresse</li>
<li>Der Zeitpunkt des Abrufs</li>
<li>Die vom zugreifenden Browser (User Agent) gemeldeten Hersteller und Art des verwendeten Browsers.</li>
</ul>
<p>Die IP Adresse gilt als personenbezogenes Datum, da mit dieser eine Identifizierung Ihrer Person m&ouml;glich ist.</p>
<p>Unser berechtigtes Interesse zur Speicherung und Verarbeitung dieser Daten folgt aus den folgenden Zwecken der Verarbeitung:</p>
<ul>
	<li>Behebung technischer Probleme</li>
	<li>Identifikation und Nachverfolgung unzul&auml;ssiger Zugriffsversuche und Zugriffe auf den Web-Server</li>
</ul>
<h4>Aufbewahrungsdauer</h4>
<p>Die protokollierten Daten beim Besuch der WikiSpeech-Webseite werden maximal für die Dauer von 16 Tagen gespeichert und dann gel&ouml;scht. Eine längere Speicherung kann im Einzelfall erfolgen, sofern ein sicherheitsrelevanter Verstoß festgestellt wurde. Die Zugriffsdaten werden dann erst nach Kl&auml;rung des Falls gel&ouml;scht.</p>
<h4>Cookies</h4>
<p>Wir verwenden sogenannte Cookies nur als technisches Hilfsmittel, damit Sie w&auml;hrend einer Sitzung bestimmte Pr&auml;ferenzen einstellen k&ouml;nnen. Das sind z.B. die Einstellung der Sprache oder das Erscheinungsbild von Tabellen.</p>
<p>Diese Cookies sind in Ihrem Browser gespeichert und werden nach Ablauf der Sitzung automatisch gel&ouml;scht.</p> 

<h4>Datenübertragung</h4>
<p>Alle sensitiven Daten werden verschl&uuml;sselt &uuml;bertragen (HTTPS Protokoll).</p>

<h4>Kontaktformular</h4>
<p>Mit dem Absenden einer Anfrage mittels des Kontaktformulars willigen Sie freiwillig ein, dass wir Ihre Anfrage zum Zwecke der Bearbeitung speichern und Sie zur Beantwortung der Anfrage kontaktieren.</p>


<h2>Teilnahme an einem Sprachaufnahme-Projekt</h2>
<h3>Rechte der betroffenen Person</h3>
<h4>Auskunftsrecht der betroffenen Person</h4>
<p>Sie k&ouml;nnen sich jederzeit an die Verantwortlichen dieser Web-Applikation wenden, um Auskunft &uuml;ber die &uuml;ber Sie gespeicherten Daten zu erhalten.
<h4>Recht auf Berichtigung</h4>
<p>Sie k&ouml;nnen sich jederzeit an die Verantwortlichen dieser Web-Applikation wenden, um auf Ihre Person bezogene Daten zu berichtigen zu lassen.</p>

<h4>Recht auf L&ouml;schung</h4>
<p>Sie k&ouml;nnen Ihr WikiSpeech-Benutzerkonto &uuml;ber die 'Profile' Seite im Benutzerkonto-Men&uuml; (Benutzer Icon in der Ecke rechts oben) l&ouml;schen oder sich jederzeit an die Verantwortlichen der Projekts oder dieser Web-Applikation wenden, um auf Ihre Person bezogene Daten l&ouml;schen zu lassen.</p>
<p>Dies gilt allerdings nicht f&uuml;r bereits erhobene Daten f&uuml;r deren Erhebung Sie Ihre Einwilligung gegeben haben. In unserem Fall sind das Ihre Sprachaufnahmen und, je nach Projekt, Sprechereigenschaften. Für die Möglichkeit einer Löschung bereits erhobener Daten kontaktieren Sie die Projektleitung des Forschungsprojektes.</p>
<p>Falls Sie sich nicht mehr an der Web-Applikation anmelden k&ouml;nnen, m&uuml;ssen Sie Ihre Identit&auml;t zur Ausf&uuml;hrung der obengenannten Rechte belegen k&ouml;nnen um einen Missbrauch Dritter zu vermeiden.</p>
<p>Ihr WikiSpeech-Benutzerkonto kann jederzeit vom Administrator des Projekts gel&ouml;scht werden.</p>

<h3>Benutzerkonto</h3>
<p>F&uuml;r ein Benutzerkonto werden folgende Daten gespeichert:<p>
<ul>
<li>Vorname</li>
<li>Nachname</li>
<li>E-Mail Adresse</li>
<li>Zeitpunkt der letzten Anmeldung</li>
</ul>
<h3>Aufnahmesitzung</h3>
<p>Bei einer Aufnahmesitzung wird zum Zwecke der Forschung und Lehre Ihre Sprache aufgenommen und gespeichert.</p>
<p>Der konkrete Forschungszweck und die weitere Verarbeitung Ihrer Daten h&auml;ngt vom jeweiligen Sprachaufnahme-Projekt ab. Entnehmen Sie diese bitte der entsprechenden Projektbeschreibung, die Ihnen die Projekt-Verantwortlichen zukommen lassen.</p>
<p>Für die Zuordnung der Aufnahmedateien wird für Sie ein Sprecherdatensatz in der Web-Applikation gespeichert. Je nach Anforderungen des Projekts werden sie eventuell auch aufgefordert Sprechermerkmale wie z.B. Geschlecht oder Alter anzugeben. Der Sprecherdatensatz wird nur mit Ihrer Einwilligung gespeichert.</p>
<p>Die eigentliche Aufnahmesitzung besteht aus mindestens einer Einzelaufnahme, in den meisten Projekten sind es mehrere kurze Aufnahmen. Sie haben volle Kontrolle darüber wann aufgenommen wird und wann die Aufnahme pausiert werden soll. Der Zeitpunkt der Aufnahmesitzung und der Einzelaufnahmen werden gespeichert.</p> 

<h3>Datenspeicherung</h3>
<p>Die Daten werden verschl&uuml;sselt &uuml;bertragen und unverschl&uuml;sselt auf Servern des Instituts für Phonetik und Sprachverarbeitung an der LMU M&uuml;nchen gespeichert.</p>
<p>Die Server des Instituts für Phonetik und Sprachverarbeitung sind in die Netzstruktur des Leibniz-Rechenzentrum
der Bayerischen Akademie der Wissenschaften eingebunden und gesch&uuml;tzt (z.B. durch eine Firewall). Die Soft- und Hardware der Server und die Netzinfrastruktur befinden sich auf dem Stand der Technik und unterliegen einer Zugangskontrolle.</p> 
<h3>Datensicherung (Backup)</h3>
<p>Die Daten der Webanwendung werden regelm&auml;ssig gesichert. Die gesicherten Daten werden dann noch verschl&uuml;sselt und an das Leibniz-Rechenzentrum
der Bayerischen Akademie der Wissenschaften &uuml;bertragen und dort gespeichert. Nach L&ouml;schung von Daten aus der Webanwendung verbleiben diese noch sieben Tage auf dem Server und sechs Monate in der Datensicherung.</p> 
<h3>Zugriffsschutz</h3>
<p>Die Zugriffsm&ouml;glichkeiten auf die Daten wird duch rollenbasierte Regelungen minimiert.</p>
<p>Die Authentifizierung erfolgt mit Nutzername und Passwort. Die Passwörter werden auf ihre Eignung &uuml;berpr&uuml;ft und verschl&uuml;sselt gespeichert.</p>

<h2>&Auml;nderung dieser Datenschutzerkl&auml;rung</h2>
<p>Wir behalten uns vor diese Datenschutzerkl&auml;rung an neue Erfordernisse anzupassen.</p>
<p>Bei Ihrem Besuch gilt immer die aktuelle Version dieser Datenschutzerkl&auml;rung</p> 
</td></tr>
</table>
</body>
</html>