package ipsk.db.speech.utils;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.RollbackException;
import javax.servlet.http.HttpServlet;

import ipsk.apps.speechrecorder.script.ItemCodeValidator;
import ipsk.db.speech.Project;
import ipsk.db.speech.script.Group;
import ipsk.db.speech.script.PromptItem;
import ipsk.db.speech.script.Script;
import ipsk.db.speech.script.Section;
import ipsk.db.speech.script.VirtualViewBox;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.db.speech.script.prompt.doc.Block;
import ipsk.db.speech.script.prompt.doc.Body;
import ipsk.db.speech.script.prompt.doc.PromptDoc;
import ipsk.db.speech.script.prompt.doc.TextFormatElement;


public class ScriptImporter {
	
	
	private String importError=null;
	
	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public ScriptImporter() {
		super();
	}
	
	private void persistTextElement(EntityManager em,TextFormatElement txtEl){
		
		em.persist(txtEl);
//		if(txtEl instanceof Font) {
//			Font txtFntEl=(Font)txtEl;
//			Text fntTextEl=txtFntEl.getText();
//			fntTextEl.setBlock(null);
//		
//		}
//		
	}
	
	private void persistBlock(EntityManager em,Block tbl){
		
		em.persist(tbl);
		
		List<TextFormatElement> txtEls=tbl.getTexts();
			for(TextFormatElement txtEl:txtEls) {
				txtEl.setBlock(tbl);
				persistTextElement(em, txtEl);
			}
		
		em.merge(tbl);
	}

	
	private void persistMediaItem(EntityManager em,Mediaitem mi){
		
		em.persist(mi);
		
		// Formatted text prompts
		
		PromptDoc prDoc=mi.getPromptDoc();
		if(prDoc!=null) {
			prDoc.setMediaitem(mi);
			prDoc.setId(mi.getMediaitemId());
			em.persist(prDoc);
			Body prBody=prDoc.getBody();
			if(prBody!=null) {
				prBody.setPromptDoc(prDoc);
				prBody.setId(prDoc.getId());
				em.persist(prBody);
				for (Block tbl : prBody.getBlocks()) {
					// should be done by cascadeType
					tbl.setBody(prBody);
					//tbl.setMediaitem(mi);
					persistBlock(em, tbl);
				}
			}
		em.merge(mi);
		}
	}

	private void persistPromptItem(EntityManager em,PromptItem pi){
		
		em.persist(pi);
		// promptitem ID

		for (Mediaitem mi : pi.getMediaitems()) {
			mi.setScope(Script.Scope.MEDIAITEM);
			mi.getPromptItemsSet().add(pi);
			persistMediaItem(em, mi);
		}
		
		em.merge(pi);
	}

	public Script importScript(EntityManager em, Script script,String assProjId) throws ImportException {
	
		importError=null;
		
		ItemCodeValidator icValidator=new ItemCodeValidator();
		List<String> icsList= script.itemCodesList();
		for(String ic:icsList) {
			if(ic==null) {
				throw new ImportException("Script contains null itemcode");
			}else {
				var vMsg=icValidator.validateItemCode(ic);
				if(vMsg!=null) {
					throw new ImportException("Itemcode "+ic+" invalid: "+vMsg);
				}
			}
		}
		
		// Reject script with duplicate itemcodes.
		List<String> duplicateItemCodes=script.duplicateItemCodes();
		if(duplicateItemCodes.size()>0) {
			throw new DuplicateItemcodesScriptImportException(duplicateItemCodes);
		}
		EntityTransaction tr = em.getTransaction();
		tr.begin();
		em.persist(script);
		// script has an now ID
		
		VirtualViewBox vvb=script.getVirtualViewBox();
		
		if(vvb!=null) {
			vvb.setRecordingscript(script);
			script.setVirtualViewBox(vvb);
			em.persist(vvb);
		}
		
		for (Section sect : script.getSections()) {

			sect.setScript(script);
			em.persist(sect);
			// section has now an ID

			for(Group g:sect.getGroups()){

				g.setSection(sect);
				// persist to generate ID
				em.persist(g);
				List<PromptItem> gPis=g.getPromptItems();
				for(PromptItem gPi:gPis){
					
					gPi.setGroup(g);
					persistPromptItem(em, gPi);
				}
				em.merge(g); // TODO should not be required ?
			}

		}
		em.merge(script);
		if(script!=null && assProjId!=null){
			// import script to project
			Project p=em.find(Project.class, assProjId);
			if(p!=null){
				p.getOwnedScripts().add(script);
				script.setOwningProject(p);
				p.getScripts().add(script);
				script.getProjects().add(p);
				em.merge(p);
				em.merge(script);
			}
		}
		try{
			tr.commit();
		}catch(RollbackException re){
			throw new ImportException("Could not import script: "+re.getMessage(),re );
		}
		return script;
	}

}
