package ipsk.webapps.db.speech;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

import ipsk.beans.PropertyValidationResult;
import ipsk.beans.validation.ValidationException;
import ipsk.beans.validation.ValidationResult;
import ipsk.db.speech.InformedConsent;
import ipsk.db.speech.Project;
import ipsk.db.speech.Speaker;
import ipsk.jsp.fmt.LocaleSupport;

public class InformedConsentController extends BasicWikiSpeechController<InformedConsent> {
	
	public InformedConsentController() {
		super("WebSpeechDBPU",InformedConsent.class);
		securityManager=new WikiSpeechSecurityManager(this);
	}
	
	public String getConsentInformText(){
		if(currentRequest==null){
			return null;
		}
		Locale loc=LocaleSupport.getLocale(currentRequest);
		ResourceBundle rb=ResourceBundle.getBundle("Messages",loc);
		
		
		Project selProject=getSelectedProject(currentRequest);
		String prjNm=selProject.getName();
		String defResearchPupose=selProject.getDefaultResearchPurpose();
		String p=rb.getString("consent.inform.text");
		String t=MessageFormat.format(p,new Object[]{prjNm,defResearchPupose});	
		return t;
		
	}
	
	public String getConsentInformedText(){
		if(currentRequest==null){
			return null;
		}
		Locale loc=LocaleSupport.getLocale(currentRequest);
		ResourceBundle rb=ResourceBundle.getBundle("Messages",loc);
		
		Project selProject=getSelectedProject(currentRequest);
		String prjNm=selProject.getName();
		
		String p=rb.getString("consent.informed.text");
		String t=MessageFormat.format(p,new Object[]{prjNm});	
		return t;
		
	}
	
	
	public String getBroadConsentInformedText(){
		if(currentRequest==null){
			return null;
		}
		Locale loc=LocaleSupport.getLocale(currentRequest);
		ResourceBundle rb=ResourceBundle.getBundle("Messages",loc);
		
		Project selProject=getSelectedProject(currentRequest);
		String prjNm=selProject.getName();
		
		String p=rb.getString("consent.informed.broad.purpose.text");
		String t=MessageFormat.format(p,new Object[]{prjNm});	
		return t;
		
	}
	
	
	public ValidationResult validate(Object o,ValidationResult validationResult) throws ValidationException{
		ValidationResult vr=super.validate(o, validationResult);
		InformedConsent ic=(InformedConsent)o;
		Project selProj=getSelectedProject();
		if(selProj!=null) {
			if(selProj.isInformedConsentPaperForm()) {
				if(! ic.isInformedConsentInPaperFormSigned()){
					vr.putPropertyValidationResult("informedConsentInPaperFormSigned",new PropertyValidationResult(PropertyValidationResult.Type.ERROR));
					vr.setType(ValidationResult.Type.ERRORS);
				}
			}else {
				String icStr=ic.getInformedConsent();
				if(icStr==null || "".equals(icStr)){
					vr.putPropertyValidationResult("informedConsent",new PropertyValidationResult(PropertyValidationResult.Type.ERROR));
					vr.setType(ValidationResult.Type.ERRORS);
				}
			}
		}
		return vr;
	}
	
	
}
