package ipsk.webapps.db.speech;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ips.beans.PersistenceMapConverter;
import ipsk.beans.BeanModel;
import ipsk.beans.MapConverter;
import ipsk.beans.MapConverterException;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.PropertyValidationResult.Type;
import ipsk.beans.validation.ValidationResult;
import ipsk.db.speech.Account;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.Project;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.account.InvitationRequest;
import ipsk.net.SendMail;
import ipsk.net.SendMailException;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.ControllerException;
import ipsk.webapps.ProcessResult;

public class OrganisationInvitationController extends InvitationController<OrganisationInvitation> {


	public OrganisationInvitationController() {
		super(OrganisationInvitation.class);
	}

	public void inviteOrganisation(HttpServletRequest req)
			throws ControllerException {
		processResult=null;
		String cmd=processCommand(req,new String[]{"invite"});
		Map<String,String[]> paramMap=req.getParameterMap();
		ValidationResult vr=new ValidationResult();

		if("invite".equals(cmd)){
			secureRequestTokenProvider.checkSecureRequestToken(req);
			EntityManager em = getThreadEntityManager();


			PersistenceMapConverter<OrganisationInvitation> mc=new PersistenceMapConverter<OrganisationInvitation>();
			OrganisationInvitation invitdata=new OrganisationInvitation();
			try {
				mc.setBeanProperties(invitdata,paramMap);
				mc.validateAndSetBeanProperties(invitdata, paramMap, true);
				String emailAddressList=invitdata.getEmail();
				InternetAddress[] testIas;
				InternetAddress orgaIas;
				PropertyValidationResult orgaPvr=null;
				PropertyValidationResult emailPvr=null;
				PropertyValidationResult loginPvr=null;
				String email=null;
				try {
					testIas = InternetAddress.parse(emailAddressList);
					if(testIas==null || testIas.length!=1){
						emailPvr=new PropertyValidationResult(Type.ERROR);
					}else{
						orgaIas=testIas[0];
						orgaIas.validate();
						email=orgaIas.getAddress();
					}

				} catch (AddressException e1) {
					emailPvr=new PropertyValidationResult(Type.ERROR, e1);
				}
				if(emailPvr==null){
					int orgaId=invitdata.getOrganisationId();
					String login=invitdata.getLogin();
					
					String localeStr=invitdata.getLocale();
					Locale locale=new Locale(localeStr);
					
					if(AccountUtils.accountExists(em,login)){
						loginPvr=new PropertyValidationResult(Type.ERROR, new LocalizableMessage("Account with this address already exists!"));
						HashMap<String, String[]> fps=new HashMap<String,String[]>();
						fps.put("login",new String[]{login});
						loginPvr.setFailedProperties(fps);
					}

					if(loginPvr==null){

						Organisation orga=em.find(Organisation.class, orgaId);
						if(orga==null) {
							orgaPvr=new PropertyValidationResult(Type.ERROR, new LocalizableMessage("Organisation with ID "+orgaId+" does not exist!"));
							HashMap<String, String[]> fps=new HashMap<String,String[]>();
							fps.put("organisationId",new String[]{Integer.toString(orgaId)});
							orgaPvr.setFailedProperties(fps);
						}

						if(orgaPvr==null) {

							SendMail sm=new SendMail();
							if(!sm.isAddressValid(email)){
								throw new ControllerException("Invalid e-mail address.");
							}else{
								// create a password reset request
								UUID uuid=UUID.randomUUID();
								Date requestDate=new Date();
								Date validUntil=new Date(requestDate.getTime()+(1000*60*60*12)); // TODO Example 12 hours 
								InvitationRequest prr=new InvitationRequest(uuid, login,email, requestDate, validUntil,orga);
								
								Set<String> userRoles=new HashSet<>();
								userRoles.add(UserRoleId.RoleName.ORGANISATION.getName());
								prr.setUserRoles(userRoles);
								
								// Expire invalid requests
								AccountController.expireInvalidAccountRequests(em);
								
								// Store
								em.persist(prr);
								
								// and set project relationships
								List<Project> prjsList=new ArrayList<>();
								for(Project orgaPrj:orga.getProjects()) {
									prjsList.add(orgaPrj);
									orgaPrj.getInvitationRequests().add(prr);
									em.merge(orgaPrj);
								}
								prr.setProjects(prjsList);
								em.merge(prr);

								// prepare E-Mail:

								// create the URL for the user to set the new password
								String url=req.getScheme()+"://"+req.getServerName()+":"+req.getServerPort()+req.getContextPath()+"/account/new_account_form.jsp?uuid="+uuid;
								//						String content=url.toString();

								ResourceBundle rb=ResourceBundle.getBundle("Messages",locale);

								String subject=rb.getString("account.create.by_invitation.organisation");
								//						
								// build mail content
								StringBuffer cb=new StringBuffer();
								String wikispeechSaluTation=rb.getString("wikispeech.salutation");
								cb.append(wikispeechSaluTation);
								cb.append(',');
								cb.append("\n\n");
								String invitationContent=rb.getString("account.create.by_invitation.message.content");
								cb.append(invitationContent);
								cb.append("\n\n");
								cb.append(url);
								cb.append("\n\n");
								String greeting=rb.getString("greeting");
								cb.append(greeting);
								cb.append("\n");
								String content=cb.toString();
								String wikiSpeechEmail=servletContext.getInitParameter("wikispeech.email_address");
								if(wikiSpeechEmail==null){
									String errMsg="Could not get WikiSpeech e-mail (sender) address (\"wikispeech.email_address\" in web.xml)";
									servletContext.log(errMsg);
									throw new ControllerException(errMsg);
								}
								try {

									sm.send(wikiSpeechEmail, email,subject, content);
									servletContext.log("Sent password reset request E-Mail from "+wikiSpeechEmail+" to "+email);
								} catch (SendMailException e) {
									servletContext.log("Could not send password reset request E-Mail",e);
									return;
								}
							}
						}
					}
				}
				if(emailPvr!=null){
					vr.putPropertyValidationResult("email",emailPvr);
					vr.setType(ValidationResult.Type.ERRORS);
				}
				if(loginPvr!=null) {
					vr.putPropertyValidationResult("login",loginPvr);
					vr.setType(ValidationResult.Type.ERRORS);
				}
				if(orgaPvr!=null) {
					vr.putPropertyValidationResult("organisationId",orgaPvr);
					vr.setType(ValidationResult.Type.ERRORS);
				}
				if(!vr.isValid()) {
					if(beanModel==null){
						beanModel=new BeanModel<OrganisationInvitation>(new OrganisationInvitation());
					}
					beanModel.setValidationResult(vr);
				}

			} catch (MapConverterException e) {
				vr.setType(ValidationResult.Type.ERRORS);
			}


			processResult=new ProcessResult(vr);
		}else {
			// command != invite
			processRequest(req);
		}
	}

	
	public void processRequest(HttpServletRequest req){
		OrganisationInvitation inv=new OrganisationInvitation();
		beanModel=new BeanModel<OrganisationInvitation>(inv);
		MapConverter mc=new MapConverter();
		try {
			mc.setBeanProperties(beanModel.getBean(),req.getParameterMap());
			Integer orgaId=inv.getOrganisationId();
			EntityManager em=getThreadEntityManager();
			Organisation orga=em.find(Organisation.class, orgaId);
			if(orga!=null) {
				inv.setName(orga.getName());
				String orgaEmail=orga.getEmail(); 
				if(orgaEmail!=null) {
					inv.setEmail(orgaEmail);
					
					if(!AccountUtils.accountExists(em, orgaEmail)) {
						// Account with E-Mail address does not exist, use E-Mail address as account login
						inv.setLogin(orgaEmail);
					}
				}
			}
			if(inv.getLogin()==null || "".equals(inv.getLogin())) {
				String suggOrgaLogin=AccountController.suggestLoginForOrganisation(em);
				inv.setLogin(suggOrgaLogin);
			}
			
			processResult=null;
		} catch (MapConverterException e) {
			ValidationResult vr=new ValidationResult();
			vr.setType(ValidationResult.Type.ERRORS);
			processResult=new ProcessResult(vr);
		}
	
	}

}
