package ipsk.webapps.db.speech;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.db.speech.FormConfiguration;
import ipsk.db.speech.PropertyConfiguration;
import ipsk.jsp.fmt.LocaleSupport;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.ControllerException;

public class PropertyConfigurationController extends BasicPersistenceBeanController<PropertyConfiguration> {
	
	public static class PropertyView{
		private String name;
		private String resourceKey;
		private String resourceBundleName;
		public String getResourceBundleName() {
			return resourceBundleName;
		}

		public String getResourceKey() {
			return resourceKey;
		}

		public String getName() {
			return name;
		}
		
		public PropertyView(String name,String resourceBundleName, String resourceKey) {
			super();
			this.name = name;
			this.resourceKey = resourceKey;
			this.resourceBundleName=resourceBundleName;
		}
		
	
		
	}
	
	private String enclosingClassId;
	private ExtBeanInfo enclosingClassBeanInfo;
	private String enclosingClassResourceBundleName;
	
	public String getEnclosingClassId() {
		return enclosingClassId;
	}
	public void setEnclosingClassId(String enclosingClassId) {
		this.enclosingClassId = enclosingClassId;
	
		Class<?> enclosingClass;
		
		String enclosingJavaClassName=getEnclosingJavaClassName();
		try {
			enclosingClass = Class.forName(enclosingJavaClassName);
			enclosingClassBeanInfo = PersistenceIntrospector.getExtendedBeanInfo(enclosingClass);
			enclosingClassResourceBundleName=enclosingClassBeanInfo.getResourceBundleName();
		} catch (ClassNotFoundException e) {		
			e.printStackTrace();
		} catch (IntrospectionException e) {
			e.printStackTrace();
		}
	}
	public PropertyConfigurationController() {
		super("WebSpeechDBPU",PropertyConfiguration.class, "property_configuration");
		securityManager=new WikiSpeechSecurityManager(this);
	}
	public PropertyConfigurationController(String persistenceUnit, String jsfIdentifier) {
		super(persistenceUnit, PropertyConfiguration.class, jsfIdentifier);
		securityManager=new WikiSpeechSecurityManager(this);
	}
	
	private String getEnclosingJavaClassName(){
		return enclosingClassId.replaceFirst("^java:","").trim();
	}
	public PropertyDescriptor[] getEnclosingClassPropertyDescriptors(){
		Class<?> enclosingClass;
		ExtBeanInfo extBeanInfo;
		String enclosingJavaClassName=getEnclosingJavaClassName();
		try {
			enclosingClass = Class.forName(enclosingJavaClassName);
			extBeanInfo = PersistenceIntrospector.getExtendedBeanInfo(enclosingClass);
			PropertyDescriptor[] pds=extBeanInfo.getPersistencePropertyDescriptors();
			return pds;
		} catch (ClassNotFoundException e) {		
			e.printStackTrace();
		} catch (IntrospectionException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public String getEnclosingClassResourceBundleName(){
		return enclosingClassResourceBundleName;
	}
	public List<PropertyView> getEnclosingClassPropertyViews(){

		PropertyDescriptor[] pds=enclosingClassBeanInfo.getPersistencePropertyDescriptors();
		
		List<PropertyView> propViews=new ArrayList<PropertyView>();
		for(PropertyDescriptor pd:pds){

			String resourceKey=enclosingClassBeanInfo.getPropertyResourceKey(pd.getName());
			PropertyView pv=new PropertyView(pd.getName(),enclosingClassResourceBundleName,resourceKey);
			propViews.add(pv);
		}
		return propViews;
	}
	
	public String formTypeNameResourceKey(PropertyConfiguration pc) {
		
		if(pc!=null) {
			String propClassId=pc.getPropertyClassId();
			return FormDefinitions.formTypeNameResourceKey(propClassId);
		}
		return null;
	}

	public LocalizableMessage propNameLocalizableMessage(PropertyConfiguration rowPc,String propNm) {
		setEnclosingClassId(rowPc.getPropertyClassId());
		LocalizableMessage lPm=new LocalizableMessage(enclosingClassResourceBundleName,enclosingClassBeanInfo.getPropertyResourceKey(propNm));
		
		return lPm;
	}

	
}
