package ipsk.webapps.db.speech.filter;

import ipsk.db.speech.Message;
import ipsk.db.speech.Project;
import ipsk.webapps.db.speech.MessageController;
import ipsk.webapps.db.speech.ProjectController;

import java.io.IOException;
import java.util.List;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ReadMessageFirstFilter implements Filter {

	private static String MESSAGES_PAGE_PATH="/session/msgs/MessagesNotify.jsp";
	
	public void destroy() {
		// nothing to do
	}

	public void doFilter(ServletRequest arg0, ServletResponse arg1,
			FilterChain arg2) throws IOException, ServletException {
		boolean forwardable=!arg1.isCommitted();
		if (arg0 instanceof HttpServletRequest){
			HttpServletRequest httpReq=(HttpServletRequest)arg0;
			
			String user=httpReq.getRemoteUser();
			HttpSession sess=httpReq.getSession(false);
			if(sess!=null && user !=null && forwardable && !httpReq.isUserInRole("ADMIN")){
				MessageController msgsCtrl=new MessageController();
				msgsCtrl.open();
				List<Message> unreadMsgs=msgsCtrl.getUnreadMessages(httpReq);
				int unreadMsgsCount=unreadMsgs.size();
				msgsCtrl.close();
				if(unreadMsgsCount>0){

					// forward to messages notify page
					RequestDispatcher rd = httpReq.getRequestDispatcher(MESSAGES_PAGE_PATH);
					rd.forward(arg0, arg1);
					return;
				}   
			}
		}
		if (arg2!=null)arg2.doFilter(arg0,arg1);

	}

	public void init(FilterConfig arg0) throws ServletException {
		// nothing to do
	}

}
