package ipsk.webapps.db.speech.project;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ipsk.beans.PropertyValidationResult;
import ipsk.beans.validation.ValidationException;
import ipsk.beans.validation.ValidationResult;
import ipsk.db.speech.Account;
import ipsk.db.speech.Project;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.project.LocalizedDefaultPurposeText;
import ipsk.db.speech.project.LocalizedInformedConsentText;
import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.persistence.QueryParam;
import ipsk.text.StringSequenceBuilder;
import ipsk.webapps.ControllerException;
import ipsk.webapps.db.speech.BasicProjectAdminController;
import ipsk.webapps.db.speech.BasicWikiSpeechController;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;

public class LocalizedInformedConsentTextsController extends BasicProjectAdminController<LocalizedInformedConsentText> {
	
	
	public LocalizedInformedConsentTextsController() {
		super("WebSpeechDBPU",LocalizedInformedConsentText.class, "localized_informed_consent_text");
	}
	
	public String getLanguageISO3codesInUseStr() {
		Set<String> lcSet=languageISO3codesInUse();
		return StringSequenceBuilder.buildString(lcSet, ',');
	}
	
	public Set<String> languageISO3codesInUse() {
		Set<String> ciu=new HashSet<String>();
		if(owningProject!=null) {
			String defLc=owningProject.getDefaultInformedConsentTextLanguageISO3code();
			if(defLc!=null) {
				ciu.add(defLc);
			}
			
			List<LocalizedInformedConsentText> licts=owningProject.getInformedConsentTextAdditionalLanguages();
			for(LocalizedInformedConsentText lict:licts) {
				String aLc=lict.getLanguageISO3code();
				if(aLc!=null) {
					ciu.add(aLc);
				}
			}
		}
		return ciu;
	}
	
	public void projectsLocalizedInformedConsentTexts(HttpServletRequest req) throws ControllerException {
		Account acc = getAccountByRequest(req);
		
		createEmptyBeanTableModel(req);
		
		if (acc != null && req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())) {
			applyOwningProject(req);
			ParameterizedQuery pq = new ParameterizedQuery(queryType);

			String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;

			pq.setWhereClause(jse +".project = :owningProject");
			pq.setQueryParams(new QueryParam[] {new QueryParam("owningProject", owningProject)});
			super.processRequest(req,pq);
		}
	}
	
	public ValidationResult validate(Object o,ValidationResult validationResult) throws ValidationException{
		ValidationResult vr=super.validate(o, validationResult);
		LocalizedInformedConsentText l=(LocalizedInformedConsentText)o;
		
		if(l.getLanguageISO3code()==null || "".equals(l.getLanguageISO3code())){
			vr.putPropertyValidationResult("languageISO3code",new PropertyValidationResult(PropertyValidationResult.Type.ERROR));
			vr.setType(ValidationResult.Type.ERRORS);
		}
		return vr;
	}
	
}
