package ipsk.webapps.db.speech.project;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ips.beans.PersistenceMapConverter;
import ipsk.beans.MapConverterException;
import ipsk.db.speech.Project;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.project.MediaStorageFormat;
import ipsk.webapps.ControllerException;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.db.speech.BasicWikiSpeechController;

public class MediaStorageFormatController extends BasicWikiSpeechController<MediaStorageFormat> {
	
	public MediaStorageFormatController() {
		super("WebSpeechDBPU",MediaStorageFormat.class, "mediaStorageFormat");
	}
	
	public void storeMediaFormat(HttpServletRequest req) throws ControllerException{
		
		createEmptyBeanTableModel(req);
		
		if (req.isUserInRole(UserRoleId.RoleName.ADMIN.name()) ||  req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())) {
			
			PersistenceMapConverter<MediaStorageFormat> mapConverter = new PersistenceMapConverter<MediaStorageFormat>();
			MediaStorageFormat msf=new MediaStorageFormat();
			try {
				EntityManager em=getThreadEntityManager();
				mapConverter.createBeanModel(msf, req.getParameterMap(), em,false, req, securityManager);
				Project prj=em.find(Project.class,msf.getName());
				msf.setProject(prj);
				MediaStorageFormat existMsf=em.find(MediaStorageFormat.class, msf.getName());
				if(existMsf!=null) {
					securityManager.checkMergePermission(req, msf);
					em.merge(msf);
				}else {
					securityManager.checkPersistPermission(req,msf);
					em.persist(msf);
				}
				prj.setMediaStorageFormat(msf);
				em.merge(prj);
				processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
			} catch (MapConverterException e) {
				
				e.printStackTrace();
				throw new ControllerException(e);
			}
		}
	}
	
}
