package ipsk.webapps.db.speech.script;

import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

import ipsk.apps.speechrecorder.script.RecscriptHandler;
import ipsk.beans.BeanModel;
import ipsk.db.speech.Account;
import ipsk.db.speech.Project;
import ipsk.db.speech.Session;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.script.Group;
import ipsk.db.speech.script.PromptItem;
import ipsk.db.speech.script.Reccomment;
import ipsk.db.speech.script.Recinstructions;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.Script;

import ipsk.db.speech.script.ScriptSyntaxException;
import ipsk.db.speech.script.Section;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.db.speech.utils.ImportException;
import ipsk.db.speech.utils.ScriptImporter;
import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.persistence.QueryParam;
import ipsk.webapps.ControllerException;
import ipsk.webapps.PermissionDeniedException;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.db.speech.BasicWikiSpeechController;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;
import ipsk.xml.DOMConverterException;

public class ScriptController extends BasicWikiSpeechController<Script> {

	public static final String SINE_TEST_SCRIPT_NAME="Sine-Test";
	
	public static final String NAME="session";
	public static final String SYSTEM_ID="SpeechRecPrompts_4.dtd";
	
	private Project owningProject=null;
	
	public ScriptController() {
		super("WebSpeechDBPU",Script.class, "script");
		securityManager=new WikiSpeechSecurityManager(this);
	}

	public Script getScriptById(int id) {
		return (Script)getById(id);
	}
	
//	public void merge(Script o){
//		super.merge(o);
//	}
//	
//	public void persist(Script o){
//		super.persist(o);
//	}

	public void deleteScript(int id) {
		EntityManager em = getThreadEntityManager();
		Script o = em.find(Script.class, id);
		em.remove(o);
	}
	

	@SuppressWarnings("unchecked")
	public List<ipsk.db.speech.script.Script> getScripts() {
	
		EntityManager em = getThreadEntityManager();
		
		List<ipsk.db.speech.script.Script> list=null;
		
		Query q = em.createQuery("select object(o) from Script as o");
		q.setMaxResults(batchSize);
		q.setFirstResult(firstItem);
		list = q.getResultList();
		return list;
	}
	
	public void accessibleScripts(HttpServletRequest req)
			throws ControllerException {
	}
	public Script getScriptWithLowestUsage(){
		
		Script script=null;
		List<Script> list=getScripts();
		int minUsed=Integer.MAX_VALUE;
		for(Script s:list){
			Set<Session> sesss=s.getSessions();
			int size=sesss.size();
			if (size<minUsed){
				script=s;
				minUsed=size;
			}
		}
		close();
		
		return script;
	}
	

	public List<Script> scriptsSortedByLowestUsage(int sessionId) {
		EntityManager em = getThreadEntityManager();
		Session sess = em.find(Session.class, sessionId);
		Project project=sess.getProject();
		CriteriaBuilder cb = em.getCriteriaBuilder();
		CriteriaQuery<Script> cq = cb.createQuery(Script.class);
		Root<Script> p = cq.from(Script.class);
		cq.select(p);
		Predicate scriptofProjectPred=cb.isMember(project, p.<Collection<Project>>get("projects"));
		Predicate notSinusTestExp=cb.notEqual(p.<String>get("name"),"Sinus-Test");
		cq.where(cb.and(scriptofProjectPred, notSinusTestExp));
		cq.orderBy(cb.desc(cb.size(p.<Collection<Session>>get("sessions"))));
		TypedQuery<Script> q = em.createQuery(cq);
		//q.setMaxResults(100);
		List<Script> resultList = q.getResultList();

		if (resultList.isEmpty())
			return null;
		else
			return resultList;
	}
//	public void newScript() {
//		
//		this.script = new Script();
//
//	}
	
	

	public void processRequest(HttpServletRequest request) throws ControllerException {
		// For debug interception only
		super.processRequest(request);
	}
	
	public void allScriptsByAccountOwnedByProject(HttpServletRequest req) throws ControllerException {
		Account acc = getAccountByRequest(req);
		
		createEmptyBeanTableModel(req);
		
		boolean isAdmin=req.isUserInRole(UserRoleId.RoleName.ADMIN.name());
		boolean isPrjAdmin=(acc!=null && req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name()));
		
		if (isAdmin || isPrjAdmin) {
			String trgClParam=req.getParameter(PersistenceObjectIdentifier.KEY_TARGET_CLASS);
			String prjNm=req.getParameter(PersistenceObjectIdentifier.KEY_ID);
			if(Project.class.getName().equals(trgClParam) && prjNm!=null) {
				EntityManager em=getThreadEntityManager();
				owningProject=em.find(Project.class,prjNm);
			}
			ParameterizedQuery pq = new ParameterizedQuery(queryType);

			String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
			if(isAdmin) {
				pq.setWhereClause("("+jse+" IN (SELECT scr FROM Script scr,Project pr WHERE "+ jse +".owningProject=pr AND scr.owningProject = :owningProject))");
				pq.setQueryParams(new QueryParam[] {new QueryParam("owningProject", owningProject)});
			}else if(isPrjAdmin) {
				pq.setWhereClause("("+jse+" IN (SELECT scr FROM Script scr,Project pr WHERE :account MEMBER OF pr.adminAccounts AND "+ jse +".owningProject=pr AND scr.owningProject = :owningProject))");
				pq.setQueryParams(new QueryParam[] { new QueryParam("account",acc) , new QueryParam("owningProject", owningProject)});
			}
			super.processRequest(req,pq);
		}
	}
	
	public void  activeApplicationOwnedScripts(HttpServletRequest req) throws ControllerException {
		
		
		boolean isAdmin=req.isUserInRole(UserRoleId.RoleName.ADMIN.name());
		
		if (isAdmin) {
			createEmptyBeanTableModel(req);
			String cmd=processCommand(req);

			if(CMD_SELECT_TO_ADD.equals(cmd)) {
				Project project=null;
				String trgClParam=req.getParameter(PersistenceObjectIdentifier.KEY_TARGET_CLASS);
				String prjNm=req.getParameter(PersistenceObjectIdentifier.KEY_ID);
				if(Project.class.getName().equals(trgClParam) && prjNm!=null) {
					EntityManager em=getThreadEntityManager();
					project=em.find(Project.class,prjNm);
				}
				ParameterizedQuery pq = new ParameterizedQuery(queryType);

				String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
				if(isAdmin) {
					pq.setWhereClause("("+jse+".owningProject IS NULL AND NOT :project MEMBER OF "+ jse +".projects)");
					pq.setQueryParams(new QueryParam[] {new QueryParam("project", project)});
				}
				super.processRequest(req,pq);
			}else {
				super.processRequest(req);
			}
		}else {
			throw new PermissionDeniedException();
		}
	}
	
	public void allScriptsByAccount(HttpServletRequest req)
			throws ControllerException {
		
		Account acc = getAccountByRequest(req);
		
		createEmptyBeanTableModel(req);
		if (acc == null)
			return;

		ParameterizedQuery pq = new ParameterizedQuery(queryType);
	
		String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;

		if(req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())){
			pq.setWhereClause("("+jse+" IN (SELECT scr FROM Script scr,Project pr WHERE :account MEMBER OF pr.adminAccounts AND "+ jse +".owningProject=pr))");
			pq.setQueryParams(new QueryParam[] { new QueryParam("account",acc) });
			super.processRequest(req,pq);
		}
	}
	
//	public void selectedProjectScriptsSortedByLowestUsageOld(HttpServletRequest req) throws ControllerException {
//		currentRequest=req;
//		Account acc = getAccountByRequest(req);
//		
//		createEmptyBeanTableModel(req);
//		if (acc == null)
//			return;
//		Project project=getSelectedProject();
//		if(project==null) {
//			return;
//		}
//		Query q=selectedProjectScriptsSortedByLowestUsageOldQuery(project, getThreadEntityManager());
//		setQuery(q);
//		super.processRequest(req);
//		
//	}
//	
//	
//	public void selectedProjectScriptsSortedByLowestUsage(HttpServletRequest req) throws ControllerException {
//		currentRequest=req;
//		Account acc = getAccountByRequest(req);
//		
//		createEmptyBeanTableModel(req);
//		if (acc == null)
//			return;
//		Project project=getSelectedProject();
//		if(project==null) {
//			return;
//		}
//		Query q=selectedProjectScriptsSortedByLowestUsageQuery(project, getThreadEntityManager());
//		setQuery(q);
//		super.processRequest(req);
//		
//	}
//	
//	public static Query selectedProjectScriptsSortedByLowestUsageOldQuery(Project project,EntityManager em ) {
//		
//			CriteriaBuilder cb = em.getCriteriaBuilder();
//			CriteriaQuery<Script> cq = cb.createQuery(Script.class);
//			Root<Script> scr = cq.from(Script.class);
//			cq.select(scr);
//			Predicate scriptofProjectPred=cb.isMember(project, scr.<Collection<Project>>get("projects"));
//			Predicate notSinusTestExp=cb.notEqual(scr.<String>get("name"),"Sinus-Test");
//			cq.where(cb.and(scriptofProjectPred, notSinusTestExp));
//			cq.orderBy(cb.asc(cb.size(scr.<Collection<Session>>get("sessions"))));
//			TypedQuery<Script> q = em.createQuery(cq);
//			return q;
//	}
//	
//	public static Query selectedProjectScriptsSortedByLowestUsageQuery(Project project,EntityManager em ) {
//		
//		
//			CriteriaBuilder cb = em.getCriteriaBuilder();
//			CriteriaQuery<Script> cq = cb.createQuery(Script.class);
//			Root<Script> scr = cq.from(Script.class);
//			
//			Predicate scriptofProjectPred=cb.isMember(project, scr.<Collection<Project>>get("projects"));
//			Predicate notSinusTestExp=cb.notEqual(scr.<String>get("name"),"Sinus-Test");
//			cq.where(cb.and(scriptofProjectPred, notSinusTestExp));
////			Subquery<Session> scriptNotTestSessionsSubQuery=cq.subquery(Session.class);
////			Root<Session> sessRoot=scriptNotTestSessionsSubQuery.from(Session.class);
////			Predicate isScriptSession=cb.equal(sessRoot.<Script>get("script"),scr);
////			Predicate isNormSessionPred=cb.equal(sessRoot.<Session.Type>get("type"), Session.Type.NORM);
////			scriptNotTestSessionsSubQuery.where(cb.and(isScriptSession,isNormSessionPred));
////			scriptNotTestSessionsSubQuery.select(sessRoot);
//			//cq.multiselect(scr.<Integer>get("scriptId"),scriptNotTestSessionsSubQuery.);
//			
//			// Left join code does not work. Postgres throws error.
//			 Join<Script,Session> scrSesss = scr.join("sessions", JoinType.LEFT);
//			 
//			 Predicate isScriptSession=cb.equal(scrSesss.<Script>get("script"),scr);
//			Predicate isNormSessionPred=cb.equal(scrSesss.<Session.Type>get("type"), Session.Type.NORM);
//			scrSesss.on(cb.and(isScriptSession,isNormSessionPred));
//			//scriptNotTestSessionsSubQuery.where(isNormSessionPred);
//			//scriptNotTestSessionsSubQuery.select(sessRoot);
//			cq.groupBy(scr.<Integer>get("scriptId"));
////		
//			//cq.orderBy(cb.asc(cb.count(scriptNotTestSessionsSubQuery)));
//			cq.select(scr);
//			System.out.println("Query with join");
//			TypedQuery<Script> q = em.createQuery(cq);
////			q.setFirstResult(0);
////			q.setMaxResults(10);
//			
//		
//			return q;
//		
//	}
//
//	
//	
//	public static List<Script> selectedProjectScriptsSortedByLowestUsage(Project project,EntityManager em ) {
//		if(project!=null){
//			
//			CriteriaBuilder cb = em.getCriteriaBuilder();
//			CriteriaQuery<Script> cq = cb.createQuery(Script.class);
//			Root<Script> scr = cq.from(Script.class);
//			cq.select(scr);
//			Predicate scriptofProjectPred=cb.isMember(project, scr.<Collection<Project>>get("projects"));
//			Predicate notSinusTestExp=cb.notEqual(scr.<String>get("name"),"Sinus-Test");
//			cq.where(cb.and(scriptofProjectPred, notSinusTestExp));
//			//Subquery<Session> scriptNotTestSessionsSubQuery=cq.subquery(Session.class);
//			//Root<Session> sessRoot=scriptNotTestSessionsSubQuery.from(Session.class);
//			 Join<Script,Session> scrSesss = scr.join("sessions", JoinType.LEFT);
//			 
//			Predicate isNormSessionPred=cb.equal(scrSesss.<Session.Type>get("type"), Session.Type.NORM);
//			scrSesss.on(isNormSessionPred);
//			//scriptNotTestSessionsSubQuery.where(isNormSessionPred);
//			//scriptNotTestSessionsSubQuery.select(sessRoot);
//			cq.groupBy(scr);
//			cq.orderBy(cb.asc(cb.count(scrSesss)));
//			TypedQuery<Script> q = em.createQuery(cq);
//			//q.setMaxResults(100);
//			List<Script> resultList = q.getResultList();
//
//			if (resultList.isEmpty())
//				return null;
//			else
//				return resultList;
//		}else{
//			return null;
//		}
//	}

	public void scriptsOwnedByProject(HttpServletRequest req)
			throws ControllerException {
		//				EntityManager em = getThreadEntityManager();
		Account acc = getAccountByRequest(req);
		Project selProject=getSelectedProject(req);
		createEmptyBeanTableModel(req);
		if (acc == null)
			return;

		ParameterizedQuery pq = new ParameterizedQuery(queryType);
		String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;

		pq.setWhereClause(jse + ".owningProject = :prj");
		pq.setQueryParams(new QueryParam[] { new QueryParam("prj", selProject) });

		super.processRequest(req,pq);
	}
	
	
	public void activeScriptsBySelectedProject(HttpServletRequest req) throws ControllerException {
		Project selProject=getSelectedProject(req);
		ParameterizedQuery pq = new ParameterizedQuery(queryType);
		String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;

		pq.setWhereClause(":prj MEMBER OF "+jse +".projects");
		pq.setQueryParams(new QueryParam[] { new QueryParam("prj", selProject) });

		super.processRequest(req,pq);
	}
	
	
	public void deleteScriptCompletely(HttpServletRequest request)
			throws ControllerException {
		Account acc = getAccountByRequest(request);
		//Project selProject=getSelectedProject(request);
		
		if (acc == null)
			return;
		
		secureRequestTokenProvider.checkSecureRequestToken(request);

		EntityManager em = getThreadEntityManager();
		beanModel=null;
		beanTableModel=null;
		
		String idStr = request.getParameter(beanInfo
				.getIdPropertyDescriptor().getName());
		try {
			setId(beanInfo.createIdValueByString(idStr));
		} catch (Exception e) {

			e.printStackTrace();
			throw new ControllerException(e);
		}
		Script scr=em.find(queryType, id);
		Project oPrj=scr.getOwningProject();
		if (request.isUserInRole(UserRoleId.RoleName.ADMIN.name()) ||
				(request.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name()) && 
						oPrj!=null &&
						oPrj.getAdminAccounts().contains(acc)
						)
				){

			// Remove media items
			for(Section sect:scr.getSections()){
				for(Group g:sect.getGroups()){
					for(PromptItem pi:g.getPromptItems()){
						for(Mediaitem mi:pi.getMediaitems()){
							em.remove(mi);
						}
						if(pi instanceof Recording) {
							Recording r=(Recording)pi;
							Recinstructions ris=r.getRecinstructions();
							if(ris!=null) {
								Set<Recording> rSet=ris.getRecordingsSet();
								if(rSet.size()==1 && rSet.contains(r)) {
									em.remove(ris);
								}else {
									rSet.remove(r);
								}
								
							}
							Reccomment rc=r.getReccomment();
							if(rc!=null) {
								Set<Recording> rSet=rc.getRecordingsSet();
								if(rSet.size()==1 && rSet.contains(r)) {
									em.remove(rc);
								}else {
									rSet.remove(r);
								}
							}
						}
					}
				}
			}
			em.remove(scr);
			beanModel=new BeanModel<Script>(scr);
			processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
		}else{
			processResult=new ProcessResult(ProcessResult.Type.ERROR);
			throw new PermissionDeniedException();
		}
	}

	

	public Script getScript() throws ControllerException {
		return (Script)getItem();
	}

//	public void setScript(Script script) {
//		this.script = script;
//	}
	
	public Document toDOM(Script script) throws ParserConfigurationException{
		DocumentBuilderFactory docFactory=DocumentBuilderFactory.newInstance();
		DocumentBuilder docBuilder=docFactory.newDocumentBuilder();
		
		// TODO use the above method with doctype
		
		//DOMImplementation domImpl=docBuilder.getDOMImplementation();
		//DocumentType docType=domImpl.createDocumentType(NAME, null,SYSTEM_ID);
		//Document d=domImpl.createDocument(null, NAME, docType);
		
		Document d=docBuilder.newDocument();
		
		d.appendChild(script.toElement(d));
	
		
		return d;
	}
	
	
	// TODO duplicate Code: ScriptImporter
	private void persistPromptItem(EntityManager em,PromptItem pi){
		
		em.persist(pi);
		// promptitem ID

		for (Mediaitem mi : pi.getMediaitems()) {
			mi.setScope(Script.Scope.MEDIAITEM);
			mi.getPromptItemsSet().add(pi);
//			mi.getPromptItems().add(pi);
			em.persist(mi);
		}
		em.merge(pi);
	}
//	// TODO duplicate Code: ScriptImporter
//	public void importScript(Script script){
//		EntityManager em = getThreadEntityManager();
//		em.persist(script);
//		// script has and ID
//		for(Section sect:script.getSections()){
//
//			sect.setScript(script);
//			em.persist(sect);
//			// section has ID
//
//			script.getSections().add(sect);
//			em.merge(script);
//			for(Group g:sect.getGroups()){
//
//				g.setSection(sect);
//				// persist to generate ID
//				em.persist(g);
//				List<PromptItem> gPis=g.getPromptItems();
//				for(PromptItem gPi:gPis){
//
//					gPi.setGroup(g);
//					persistPromptItem(em, gPi);
//				}
//				em.merge(g); // TODO should not be required ?
//			}
//		}
//	}
//	
//	
	public void importScript(Reader isr) throws DOMConverterException, ScriptSyntaxException, ImportException{
		// get DTD as resource
		URL systemIdURL = getClass().getResource(RecscriptHandler.REC_SCRIPT_DTD);
		
		InputSource is=new InputSource(isr);
		
        if(systemIdURL!=null){
        	String systemId=systemIdURL.toExternalForm();
            is.setSystemId(systemId);
        }
        RecscriptHandler rsh=new RecscriptHandler();
        Document d=rsh.readXML(is);
        Element rootE=d.getDocumentElement();
        Script s=new Script(rootE);
       
        ScriptImporter scriptImporter=new ScriptImporter();
        
        scriptImporter.importScript(getThreadEntityManager(),s,null);
		
	}

	
	public Script getScriptBySessionId(int sessionId) {
		Script s=null;
		EntityManager em = getThreadEntityManager();
		
			Session sess=em.find(Session.class,sessionId);
			em.refresh(sess);
		s=sess.getScript();
		em.refresh(s);
		return s;
		
	}

	@SuppressWarnings("unchecked")
	public Script getSinusTestScript() {
		EntityManager em = getThreadEntityManager();

		List<ipsk.db.speech.script.Script> list=null;
		
		Query q = em.createQuery("select object(o) from Script as o where o.name='"+SINE_TEST_SCRIPT_NAME+"'");
		q.setHint("toplink.refresh", "true");
		q.setMaxResults(1);
		q.setFirstResult(0);
		list = q.getResultList();
		return list.get(0);
	}
	
	

	

}
