package ipsk.webapps.db.speech.session;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ipsk.db.speech.Session;
import ipsk.db.speech.Speaker;
import ipsk.webapps.ControllerException;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.db.speech.SessionController;

public class MultipleSessionDeleteController extends SessionController {

	private String projectName=null;
	
	public String getProjectName() {
		return projectName;
	}

	private Integer deletedSessionsCount=null;
	
	public Integer getDeletedSessionsCount() {
		return deletedSessionsCount;
	}

	public void processRequest(HttpServletRequest req) throws ControllerException {
		currentRequest=req;
		deletedSessionsCount=null;
		String cmd=processCommand(req);
		
		String projectNameParam=req.getParameter("project.name");
		if(projectNameParam!=null) {
			projectName=projectNameParam;
		}
		if(CMD_STORE_DELETE_RELATED.equals(cmd)) {
			if(checkSecureRequestToken) {
				secureRequestTokenProvider.checkSecureRequestToken(req);
			}
			Map<String,String[]> pm=req.getParameterMap();
			String[] sessIdStrs=pm.get("sessions.sessionId");
			EntityManager em=getThreadEntityManager();
			List<Session> sesss=new ArrayList<Session>();
			if(sessIdStrs!=null) {
				for(String sessIdStr:sessIdStrs) {
					try {
						Integer sessId=Integer.parseInt(sessIdStr);
						Session sess=em.find(Session.class, sessId);
						securityManager.checkRemovePermission(req, sess);
						sesss.add(sess);
					}catch(NumberFormatException nfe) {
						throw new ControllerException("Could not parse as integer for session id: "+sessIdStr);
					}

				}
			}
			for(Session session:sesss) {
				Set<Speaker> sessSpks=session.getSpeakers();
				for (Speaker sessSpk:sessSpks) {
					Set<Session> sessSpkSesss=sessSpk.getSessions();
					if(sessSpkSesss.size()==1) {
						// Speaker has only this session
						if(sessSpk.getAccount()==null) {
							// Speaker object has no account
							// Remove the speaker object
							em.remove(sessSpk);
						}
						
					}
				}
				super.deleteSessionWithRecordingFileDirectory(req,session);
			}
			deletedSessionsCount=sesss.size();
			processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
		}else if(CMD_CANCEL_STORE_RELATED.equals(cmd)) {
			processResult=new ProcessResult(ProcessResult.Type.CANCELLED);
		}else {
			super.processRequest(req);
		}
	}

}
