package ipsk.webapps.db.speech.ws;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.List;
import java.util.Locale;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.ResponseBuilder;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.StreamingOutput;

import org.glassfish.jersey.server.internal.scanning.ResourceProcessor;

import ipsk.io.StreamCopy;
import ipsk.net.MIMEType;
import ipsk.webapps.db.servlets.FileServer;
import ipsk.webapps.db.speech.ProjectController;


public class ProjectResourcesResource{

	private String projectName;
	private static File baseDir;
	
	public ProjectResourcesResource(String projectName) {
		this.projectName = projectName;
	}


	@GET
	@Produces({MediaType.WILDCARD})
	@Path("/{pathSegments:.*}")
	public Response projectResource(@Context HttpServletRequest req, @PathParam("pathSegments") List<PathSegment> pathSegments) {
		
		ServletContext sc=req.getServletContext();
		String baseDirPath = sc.getInitParameter(FileServer.BASE_DIR_PARAMETER_KEY);

		java.nio.file.Path resPath=null;

		if(baseDirPath!=null){

			File baseDir=new File(baseDirPath);

			java.nio.file.Path projectsPath=baseDir.toPath().resolve(FileServer.PROJECTS_DIR);
			java.nio.file.Path projectPath=projectsPath.resolve(projectName);
			resPath=projectPath.resolve(FileServer.RESOURCES_DIR);


			for(PathSegment ps:pathSegments) {
				resPath=resPath.resolve(ps.toString());
			}
			resPath=resPath.normalize();
			if(!Files.exists(resPath)) {
				return Response.status(Status.NOT_FOUND).build();
			}
			if(Files.isRegularFile(resPath)) {

				MIMEType mimeType=MIMEType.knownMimeTypeByPath(resPath);
				
				try {

					final InputStream resIs=new FileInputStream(resPath.toFile());
					StreamingOutput streamOutput = new StreamingOutput() {

						@Override
						public void write(OutputStream outputStream)
								throws IOException, WebApplicationException {
							StreamCopy.copy(resIs, outputStream);
						}
					};
					ResponseBuilder rb=Response.ok(streamOutput);
					if(mimeType!=null) {
						rb=rb.type(mimeType.toString());
					}
					return rb.build();

				} catch (IOException mue) {
					return Response.serverError().build();
				}

			}else {
				return Response.noContent().build();
			}
		}else {
			return Response.serverError().build();
		}
		}
}

