package ipsk.webapps.db.speech.ws;

import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import ipsk.db.speech.Account;
import ipsk.db.speech.Project;
import ipsk.db.speech.Session;
import ipsk.db.speech.SessionDTO;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.script.Script;
import ipsk.persistence.EntityManagerProvider;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.db.speech.AccountController;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;


public class WikispeechBasicResource<T>{

	protected Class<T> entityClass;
	
	public final static String UUID_PROPERTY_NAME="uuid";
	
	public WikispeechBasicResource(Class<T> entityClass){
		super();
		this.entityClass=entityClass;
	}
	
	
	public static Account getAccountByRequest(HttpServletRequest req,EntityManager em){
		return AccountController.getAccountByRequest(req, em);
	}
	
	protected T entityByUUID(EntityManager em,UUID uuid){
		CriteriaBuilder cb = em.getCriteriaBuilder();
		CriteriaQuery<T> cq = cb.createQuery(entityClass);
		Root<T> rt = cq.from(entityClass);
		cq.select(rt);
		cq.where(cb.equal(rt.get(UUID_PROPERTY_NAME), uuid.toString()));

		TypedQuery<T> q = em.createQuery(cq);
		List<T> entsList=q.getResultList();
		if(entsList.isEmpty()){
			return null;
		}else{
			return entsList.get(0);
		}
	}
	
	
	protected Response get(HttpServletRequest req,String idStr){
		Integer entId=null;
		UUID entUUID=null;
		try{
			entId=Integer.parseInt(idStr);
		}catch(NumberFormatException nfe){
			entId=null;
			try{
				entUUID=UUID.fromString(idStr);
			}catch(IllegalArgumentException iae){
				return Response.status(Status.BAD_REQUEST).build();
			}
		}
		T ent=null;
		final EntityManager em=EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		try{
			if(entId!=null){
				ent=em.find(entityClass, entId);
			}else if(entUUID!=null){
				ent=entityByUUID(em, entUUID);
			}
			if(ent==null){
				return Response.status(Status.NOT_FOUND).build();
			}

			WikiSpeechSecurityManager securityManager = new WikiSpeechSecurityManager(new EntityManagerProvider() {
				@Override
				public EntityManager getThreadEntityManager() {
					return em;
				}
			});
			if(!securityManager.getReadPermission(req, ent)){
				return Response.status(Status.FORBIDDEN).build();
			}

			return Response.ok(ent).build();
		}finally{
			em.close();
		}
	}

}
