package ipsk.webapps.db.speech.ws.pub;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;

import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces("audio/wav")
public class WavFileBodyWriter implements MessageBodyWriter<WavFileEntity>{

	@Override
	public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
		
		boolean isWav="audio".equals(mediaType.getType()) && "wav".equals(mediaType.getSubtype());
		return WavFileEntity.class.equals(type) && isWav;
	}

	@Override
	public void writeTo(WavFileEntity t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream)
			throws IOException, WebApplicationException {

		Path wavFile=t.getWavFile();
		long len=Files.size(wavFile);
		httpHeaders.putSingle("Content-Length", len);
		Files.copy(wavFile,entityStream);
		if(t.isDelete()) {
			try {
				Files.delete(wavFile);
			}catch(IOException ioe) {
				ioe.printStackTrace();
				wavFile.toFile().deleteOnExit();
			}
		}
	}
}
