package ipsk.webapps.db.speech.ws.pub;

//import javax.ws.rs.ApplicationPath;

import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.server.ResourceConfig;

import ipsk.webapps.db.speech.ws.ExceptionListener;
import ipsk.webapps.db.speech.ws.JsonMoxyConfigurationContextResolver;

// Now declared in web.xml servlet-mappings to have second access path for Angular
//@ApplicationPath("/api/v1")
public class WikiSpeechPublicApplication extends ResourceConfig{
	
	
	public WikiSpeechPublicApplication() {
		super();
		register(LoggingFeature.class);
		property(LoggingFeature.LOGGING_FEATURE_LOGGER_LEVEL_SERVER, "FINEST");
       
		// tracing, logging commented out
        //property("jersey.config.server.tracing.type", "ALL");
        //property("jersey.config.server.tracing.threshold", "VERBOSE");
        
        //property("org.glassfish.jersey.tracing.level","FINER");
        
		// Use Eclipse Moxy for marshalling/unmarshalling 
		register(org.glassfish.jersey.moxy.json.MoxyJsonFeature.class);
		
        //Configure MoXY (e.g. pretty print)
        register(JsonMoxyConfigurationContextResolver.class);
        
     	// register event listener to log MoXY marshalling execption to stderr (-> catalina.out) 
        register(ExceptionListener.class);
        
        register(WavFileBodyWriter.class);
        // Add resources
        register(PseudonymizedPublicRecordingfileResource.class);
		
		
	}
}
