<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" scope="request"/>
<fmt:setBundle basename="ipsk.db.speech.PropertyNames" scope="request" var="bndlSpDb"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="project.edit"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="project.edit"/></h2>

<jsp:useBean id="projectEditCtrl" scope="session" class="ipsk.webapps.db.speech.ProjectController" />
<jsp:useBean id="defaultMediaCaptureFormat" scope="session" class="ipsk.db.speech.project.MediaCaptureFormat" />
<jsp:useBean id="defaultMediaStorageFormat" scope="session" class="ipsk.db.speech.project.MediaStorageFormat" />

<ips:ctrl_process controller="${projectEditCtrl}" checkSecureRequestToken="true">

<c:url var="scriptImportUrl" scope="request" value="/prjdb/script/ScriptImport.jsp">
 <c:param name="project.name" value="${projectEditCtrl.item.name}"/>
</c:url>

<ips:bform bean="${projectEditCtrl.item}" action="/db/project/ProjectEdit" actionCommand="store" beanIdPropertyVar="bIdProp" beanIdVar="bId" props="*" tableClass="db">

<ips:pedit name="defaultResearchPurposeLanguageISO3code" var="drplic">
<tr><td><ips:pdescr/></td><td><ips:languageSelect standard="ISO-639-3" name="defaultResearchPurposeLanguageISO3code" value="${drplic}" nullable="true"/></td></tr>
</ips:pedit>

<ips:pedit name="defaultInformedConsentTextLanguageISO3code" var="dictlic">
<tr><td><ips:pdescr/></td><td><ips:languageSelect standard="ISO-639-3" name="defaultInformedConsentTextLanguageISO3code" value="${dictlic}" nullable="true"/></td></tr>
</ips:pedit>

<ips:pedit name="invitationRequests" var="invReqs">
<tr><td><ips:pdescr/></td><td><a href="<ips:brelurl action="/db/account/request/InvitationRequests.jsp"/>">#<c:out value="${fn:length(invReqs)}"/></a></td></tr>
</ips:pedit>

<ips:pedit name="adminAccounts" var="admins">
<tr><td><ips:pdescr/></td>
<td><c:forEach items="${admins}" var="adminAcc"><c:out value="${adminAcc.login}"/> </c:forEach><ips:pselect href="../account/Accounts.jsp"/></td></tr>
</ips:pedit>

<ips:pedit name="allowedSpeechRecorderClients" var="asprcs">
<tr><td><ips:pdescr/></td>
<td>
<c:if test="${empty asprcs}">
<fmt:message key="project.allowed_speechrecorder_clients"/><input type="hidden" name="allowedSpeechRecorderClients._set_null" value="null"/>
</c:if>
<c:if test="${not empty asprcs}">
<table>
<c:forEach items="${asprcs}" var="asprc"><tr><td><c:out value="${asprc}"/><input type="hidden" name="allowedSpeechRecorderClients" value="<c:out value="${asprc}"/>"/></td></tr> </c:forEach>
</table>
</c:if>
<ips:pselect href="SpeechRecorderClients.jsp"/>
</td></tr>
</ips:pedit>

<ips:pedit name="audioDevices" var="ads">
<tr><td><ips:pdescr/></td>
<td>
<c:if test="${empty ads}">
<fmt:message key="audio.device.none_selected"/><input type="hidden" name="audioDevices._set_null" value="null"/>
</c:if>
<c:if test="${not empty ads}">
<table>
<c:forEach items="${ads}" var="ad"><tr><td><c:out value="${ad}"/><input type="hidden" name="audioDevices.audioDeviceId" value="<c:out value="${ad.audioDeviceId}"/>"/></td></tr> </c:forEach>
</table>
</c:if>
<ips:pseladd href="audio/AudioDevices.jsp"/><ips:pselremove href="audio/AudioDevices.jsp">[<fmt:message key="remove"/>]</ips:pselremove>
</td></tr>
</ips:pedit>

<ips:pedit name="organisations" var="orgs">
<tr><td><ips:pdescr/></td>
<td>
<c:if test="${empty orgs}">
<fmt:message key="organisation.none_selected"/><input type="hidden" name="organisations._set_null" value="null"/>
</c:if>
<c:if test="${not empty orgs}">
<table>
<c:forEach items="${orgs}" var="org"><tr><td><c:out value="${org.name}"/><input type="hidden" name="organisations.organisationId" value="<c:out value="${org.organisationId}"/>"/></td></tr> </c:forEach>
</table>
</c:if>
<ips:pselect href="../organisation/Organisations.jsp"/>
</td></tr>
</ips:pedit>

<ips:pedit name="accounts" var="accs">
<tr><td><ips:pdescr/></td>
<td>
<c:if test="${empty accs}">
<fmt:message key="none"/><input type="hidden" name="accounts._set_null" value="null"/>
</c:if>
<c:if test="${not empty accs}">
<table>
<c:forEach items="${accs}" var="acc"><tr><td><c:out value="${acc.login}"/><input type="hidden" name="accounts.login" value="<c:out value="${acc.login}"/>"/></td></tr> </c:forEach>
</table>
</c:if>
<ips:pselect href="../account/Accounts.jsp"/>
</td></tr>
</ips:pedit>

<ips:pedit name="ownedScripts" var="oscrs">
 <tr><td><ips:pdescr/></td>
  <td><a href="<ips:brelurl action="/prjdb/script/ProjectOwningScripts.jsp"/>">#<c:out value="${fn:length(oscrs)}"/></a> [<a href="<c:out value="${scriptImportUrl}"/>"><fmt:message key="script.import"/></a>]</td></tr>
</ips:pedit>

<ips:pedit name="scripts" var="scrs">
 <tr><td><ips:pdescr/></td>
  <td><a href="<ips:brelurl action="/prjdb/script/ActiveScripts.jsp"/>">#<c:out value="${fn:length(scrs)}"/></a> <ips:pseladd href="/prjdb/script/NonActiveScripts.jsp">[Add project owned]</ips:pseladd> <ips:pseladd href="../script/ActiveApplicationScripts.jsp">[Add application owned]</ips:pseladd> <ips:pselremove href="/prjdb/script/ActiveScripts.jsp"/></td></tr>
</ips:pedit>

<ips:pedit name="dialectRegions" var="drs">
<tr><td><ips:pdescr/><td>#<c:out value="${fn:length(drs)}"/><ips:pselect href="region/DialectRegions.jsp"/></td></tr>
</ips:pedit>

<ips:pedit name="recordingDeviceWakeLock" defaultOptionResourceKey="application.default.no"/>

<ips:pedit name="chunkedRecording" defaultOptionResourceKey="application.default.no"/>

<ips:pedit name="clientAudioStorageType" defaultOptionResourceKey="storage.type.app_default.mem_entire" defaultOptionResourceBundle="ipsk.db.speech.PropertyNames"/>

<ips:pedit name="audioFormat" var="af">
 <c:if test="${not empty af}">
  <tr>
   <td><ips:pdescr/></td>
   <td>
    <c:if test="${af == null}">
     <fmt:message key="audio.format.none_selected"/><input type="hidden" name="audioFormat._set_null" value="null"/>
    </c:if>
    <c:if test="${af !=null}">
     <c:out value="${af}"/><input type="hidden" name="audioFormat.name" value="<c:out value="${af.name}"/>"/>
    </c:if>
    <ips:pselset href="audio/AudioFormats.jsp">[<fmt:message key="select"/>]</ips:pselset><ips:pselreset href="audio/AudioFormats.jsp"/>
   </td>
  </tr>
 </c:if>
</ips:pedit>

<ips:pedit name="mediaCaptureFormat" var="mcf">
	<c:if test="${empty projectEditCtrl.item.audioFormat}">
	<c:set var="currMcf" scope="request" value="${defaultMediaCaptureFormat}"/>
	<c:if test="${not empty projectEditCtrl.item.mediaCaptureFormat}">
	 <c:set var="currMcf" scope="request" value="${projectEditCtrl.item.mediaCaptureFormat}"/>
	</c:if>
	<c:url value="MediaCaptureFormatEdit.jsp" var="mcfEditUrl">
		<c:param name="_cmd" value="edit_or_new"/>
		<c:param name="name" value="${projectEditCtrl.item.name}"/>
	</c:url>
		<tr>
			<td><ips:pdescr/></td>
			<td><c:out value="${currMcf}"/> <a href="<c:out value="${mcfEditUrl}"/>">[<fmt:message key="edit"/>]</a></td>
		</tr>
	</c:if>
</ips:pedit>

<ips:pedit name="mediaStorageFormat" var="msf">
	<c:if test="${empty projectEditCtrl.item.audioFormat}">
		
		<c:set var="currMsf" scope="request" value="${defaultMediaStorageFormat}"/>
		<c:if test="${not empty projectEditCtrl.item.mediaStorageFormat}">
			<c:set var="currMsf" scope="request" value="${projectEditCtrl.item.mediaStorageFormat}"/>
		</c:if>
		<c:url value="MediaStorageFormatEdit.jsp" var="msfEditUrl">
			<c:param name="_cmd" value="edit_or_new"/>
			<c:param name="name" value="${projectEditCtrl.item.name}"/>
		</c:url>
		<tr><td><ips:pdescr/></td>
			<td><c:out value="${currMsf}"/> <a href="<c:out value="${msfEditUrl}"/>">[<fmt:message key="edit"/>]</a></td>
		</tr>
	</c:if>
</ips:pedit>

<ips:pview name="sessions" action="/db/session/Sessions.jsp" />

<ips:pedit name="sessionFinishedMessage" action="text/LocalizableMessages.jsp" />

<ips:pedit name="speakerFormConfiguration" action="forms/speaker/FormConfigurations.jsp?propertyClassId=java:ipsk.db.speech.Speaker"/>
</ips:bform>

<p><fmt:message key="help.research.purpose.default" bundle="${bndlSpDb}"/></p>

<c:url var="inviteProjectAdminUrl" scope="request" value="/db/project/InviteProjectAdmin.jsp">
<c:param name="project.name" value="${projectEditCtrl.item.name}"/>
</c:url>
<p><a href="<c:out value="${inviteProjectAdminUrl}"/>"><fmt:message key="project_admin.invite"/></a></p>

<c:url var="inviteSpkUrl" scope="request" value="/prjdb/project/InviteSpeaker.jsp">
<c:param name="project.name" value="${projectEditCtrl.item.name}"/>
</c:url>
<p><a href="<c:out value="${inviteSpkUrl}"/>"><fmt:message key="speaker.invite"/></a></p>

</ips:ctrl_process>

</td></tr>
</table>
</body>
</html>
