<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" scope="request"/>
<fmt:setBundle basename="ipsk.db.speech.PropertyNames" scope="request" var="bndlSpDb"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="account.delete.request"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="account.delete.request"/></h2>		 
 
<jsp:useBean id="accountViewCtrl" scope="request" class="ipsk.webapps.db.speech.AccountController"/>
<ips:ctrl_process controller="${accountViewCtrl}" processMethod="deleteAccount" checkSecureRequestToken="true">
<ips:ctrl_div>
<ips:bview bean="${accountViewCtrl.item}" actionCommand="delete" tableClass="dbView">
<ips:pview name="userRoles" var="urs">
<tr><td><ips:pdescr/></td><td>
<c:choose>
 <c:when test="${accountViewCtrl.item.editable}">
  <c:forEach items="${urs}" var="ur" varStatus="ursLoopStatus">
  <fmt:message key="${ur.id.roleName.resourceKey}" bundle="${bndlSpDb}"/> (<c:out value="${ur.id.roleName.name}"/>)<c:if test="${!ursLoopStatus.last}">,</c:if>
  </c:forEach>
 </c:when>
 <c:otherwise>(roles are defined in directory service <c:out value="${initParam['directoryServiceDisplayName']}"/>)</c:otherwise>
</c:choose>
</td></tr>
</ips:pview>
<ips:pview name="person" var="pers">
<tr><td><ips:pdescr/></td><td>
<c:if test="${not empty pers and pers['class'].simpleName eq 'Speaker'}">
<span<c:if test="${fn:length(pers.sessions) eq 0}"> style="color:red"</c:if>><fmt:message key="delete"/></span> 
<c:choose>
<c:when test="${fn:length(pers.sessions) gt 0}">
<!-- Disable deletion of person if this person is a speaker which already participated in sessions -->
<input type="checkbox" name="_delete_rel.person.personId" disabled="disabled" readonly="readonly">
</c:when>
<c:otherwise>
<!-- Force deletion of person which has not yet participated in session. This would cause an completely unrelated speaker -->
<input type="checkbox" name="_delete_rel.person.personId" disabled="disabled" readonly="readonly" checked="checked" value="<c:out value="${pers.personId}"/>">
</c:otherwise>
</c:choose>
<c:url value="/prjdb/speaker/SpeakerView.jsp" var="speakerViewUrl">
<c:param name="_cmd" value="view"/>
<c:param name="personId" value="${pers.personId}"/>
</c:url>
<a href="${speakerViewUrl}"><c:out value="${pers}"/></a>
</c:if>
</td></tr>
</ips:pview>
<ips:pview name="organisation" action="/prjdb/organisation/OrganisationOverview.jsp"/>
<ips:pview name="projects" action="/prjdb/project/Projects.jsp"/>
</ips:bview>
<p class="warn"><fmt:message key="deletion.cannot.be.undone"/></p>
<c:if test="${not empty accountViewCtrl.item.person}">
 <p><fmt:message key="account.speaker.associated"/></p>
<c:choose>
<c:when test="${fn:length(accountViewCtrl.item.person.sessions) gt 0}">
 <p><fmt:message key="account.speaker.associated.participant.cannot.deleted"/></p>
</c:when>
<c:otherwise>
 <p><fmt:message key="account.speaker.associated.not.participant.will.be.deleted"/></p>
</c:otherwise>
</c:choose>
</c:if>
</ips:ctrl_div>
<ips:ctrl_div result="success">
<p><fmt:message key="account.delete.confirm"><fmt:param value="${accountViewCtrl.item.login}"/></fmt:message></p>
</ips:ctrl_div>
<ips:ctrl_div result="cancel">
<p><fmt:message key="cancelled"/></p>
</ips:ctrl_div>
</ips:ctrl_process>
</td></tr>
</table>
</body>
</html>
