<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" scope="request"/>
<html>
<head>
<script src="<c:url value="/lib/script/ips_lib.js"/>" type="text/javascript"></script>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="sessions.delete"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="sessions.delete"/></h2>		 
 
<jsp:useBean id="sessMultiDeleteCtrl" scope="session" class="ipsk.webapps.db.speech.session.MultipleSessionDeleteController" />
<ips:ctrl_process controller="${sessMultiDeleteCtrl}" checkSecureRequestToken="true">
<ips:ctrl_div>
<ips:boolExpr/><br>
<ips:orderby/><br>
<ips:btable actionOnSelected="/prjdb/session/SessionsOfProjectDelete" tableClass="db" defColOrder="sessionId,project,date,script,speakers,recordingFiles,comment,actions" beanVar="rowSession">
<ips:btcustomize/>

<ips:col name="script" href="../script/ScriptView.jsp"/>
<ips:col name="speakers" href="../speaker/Speakers.jsp" maxListLength="1" var="spks">
<td>
<c:if test="${not empty spks}">
<table>
 <tr><th><span style="color:red"><fmt:message key="delete"/></span></th><th><fmt:message key="id"/></th><th><fmt:message key="speaker"/></th></tr>
<c:forEach items="${spks}" var="spk">
<c:if test="${fn:length(spk.sessions) == 1}">
<!-- Force deleting the speaker if this is the only session the speaker is involved and if the speaker has no associated account -->
 <tr><td><input type="checkbox" name="_dummy_rel.speakers.personId" disabled readonly value="<c:out value="${spk.personId}"/>"<c:if test="${empty spk.account}"> checked="checked"</c:if>/></td>
	  <td><c:out value="${spk.personId}"/></td><td><c:out value="${spk}"/></td>
</tr>
</c:if>
<c:if test="${fn:length(spk.sessions) >= 2}">
<!-- Disable speaker deletion if the speaker is involved in other sessions-->
<tr><td><input type="checkbox" name="_dummy.speakers.personId" disabled="disabled" readonly="readonly" value="<c:out value="${spk.personId}"/>"/></td><td><c:out value="${spk.personId}"/></td><td><c:out value="${spk}"/></td></tr>
</c:if>
</c:forEach>
</table>
</c:if>
<c:if test="${empty spks}">#0</c:if>
</td>
</ips:col>


<ips:col name="recordingFiles" var="rfs">
<td><c:if test="${fn:length(rfs)>0}"><span style="color:red"></c:if>#<c:out value="${fn:length(rfs)}"/><c:if test="${fn:length(rfs)>0}"> Will be deleted!</span></c:if></td>
</ips:col>

<ips:btrowaction href="SessionView.jsp" name="view" />
<ips:btrowaction href="SessionExport" name="export"/>
<ips:btrowaction href="SessionEdit.jsp" name="edit"/>
</ips:btable>
<p class="warn"><fmt:message key="deletion.cannot.be.undone"/></p>
<ips:page_navigation/>
<ips:page_position/>
<ips:items_position/>
</ips:ctrl_div>

<ips:ctrl_div result="success">
<p><fmt:message key="sessions.delete.confirm"><fmt:param value="${sessMultiDeleteCtrl.deletedSessionsCount}"/></fmt:message></p>
</ips:ctrl_div>
<ips:ctrl_div result="cancel">
<p><fmt:message key="cancelled"/></p>
</ips:ctrl_div>
<ips:ctrl_div result="error">
<p><fmt:message key="error"/></p>
</ips:ctrl_div>
</ips:ctrl_process>

</td></tr>
</table>
</body>
</html>
