<!DOCTYPE html>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>

<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" import="ipsk.db.speech.SpeechRecorderClient" %>
<fmt:setBundle basename="Messages" scope="request"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <c:choose><c:when test="${param._test_session == 'true'}"><fmt:message key="session.test.new"/></c:when><c:otherwise><fmt:message key="session.new"/></c:otherwise></c:choose></title>

</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><c:choose><c:when test="${param._test_session == 'true'}"><fmt:message key="session.test.new"/></c:when><c:otherwise><fmt:message key="session.new"/></c:otherwise></c:choose></h2>		 

<jsp:useBean id="sessCtrl" scope="session" class="ipsk.webapps.db.speech.SessionController" />
<ips:ctrl_process controller="${sessCtrl}" checkSecureRequestToken="true">

<ips:ctrl_div>

<form method="POST" action="<c:url value="/session/db/session/SessionNew"/>" accept-charset="UTF-8" enctype="application/x-www-form-urlencoded;charset=utf-8">
<ips:psecuretoken/>
<!--  TODO integrate in single form -->

<ips:bedit actionCommand="add" props="project,type,speakers,script,speechRecorderClient,comment">

<ips:pedit name="script">
<c:if test="${not empty sessCtrl.activeScriptsBySelectedProject}">
<tr><td><ips:pdescr/></td><td>
<c:choose>
<c:when test="${sessCtrl.manualScriptSelection}">
<!--  session form with script selector-->
<select name="script.scriptId">
	<optgroup>
	<option class="toSelect" value="" selected>--<fmt:message key="recscript.select.please"/>--</option>
	</optgroup>
	<optgroup>
	<c:forEach items="${sessCtrl.activeScriptsBySelectedProjectSortedByNameAndId}" var="activeScript">
 	<option value="${activeScript.scriptId}"><c:out value="${activeScript}"/> (ID: <c:out value="${activeScript.scriptId}"/>)</option>
	</c:forEach>
	</optgroup>
</select>
</c:when>
<c:otherwise>
<c:choose>
<c:when test="${param._test_session == 'true' or sessCtrl.item.type == 'TEST' or sessCtrl.item.type == 'TEST_DEF_A'}">
<c:set value="${sessCtrl.selectedProjectScriptWithLowestTestUsage}" var="scriptLowestUsage" />
</c:when>
<c:otherwise>
<c:set value="${sessCtrl.selectedProjectScriptWithLowestUsage}" var="scriptLowestUsage" />
</c:otherwise>
</c:choose>
<input type="hidden" name="script.scriptId" value="${scriptLowestUsage.scriptId}" readonly="readonly"/><c:out value="${scriptLowestUsage}"/> (ID: <c:out value="${scriptLowestUsage.scriptId}"/>)
</c:otherwise>
</c:choose>
</td><td><ips:pvalidationresult/></td></tr>
</c:if>
</ips:pedit>

<ips:pedit name="type">

<c:choose>
<c:when test="${param._test_session == 'true' or sessCtrl.item.type == 'TEST' or sessCtrl.item.type == 'TEST_DEF_A'}">
<!--  Show selector to choose between test session with or without required audio device -->
<tr><td><ips:pdescr/></td><td>
<select name="type">

<option <c:if test="${sessCtrl.item.type == 'TEST'}">selected="selected"</c:if> value="TEST"><fmt:message  bundle="${msgs}" key="session.test"/></option>
<option <c:if test="${sessCtrl.item.type == 'TEST_DEF_A'}">selected="selected"</c:if> value="TEST_DEF_A"><fmt:message  bundle="${msgs}" key="session.test.default.audio"/></option>
</select>
</td></tr>
</c:when>
<c:otherwise>
<input type="hidden" name="type" value="NORM">
</c:otherwise>
</c:choose>
</ips:pedit>

<ips:pedit name="speechRecorderClient">
<c:choose>
<c:when test="${fn:length(sessCtrl.selectedProject.allowedSpeechRecorderClients)==1}">
	<c:set var="ac" value="${sessCtrl.selectedProject.allowedSpeechRecorderClients[0]}"/>
	<input name="speechRecorderClient" type="hidden" value="${ac.name}" readonly="readonly"/>
	
</c:when>
<c:otherwise>
<tr><td><ips:pdescr/></td>
<td>
<select name="speechRecorderClient">
	<c:forEach items="${sessCtrl.selectedProject.allowedSpeechRecorderClients}" var="ac">
 	<option value="${ac.name}"><c:out value="${ac.value}"/></option>
	</c:forEach>
</select>
</td>
</c:otherwise>
</c:choose>
</ips:pedit>

</ips:bedit>

<c:set var="accOrganisation" scope="request" value="${sessCtrl.sessionAccount.organisation}"/>
<c:if test="${accOrganisation != null}">
<input type="hidden" name="organisation.organisationId" value="${accOrganisation.organisationId}">
</c:if>

<!--  <input type="hidden" name="uuid" value="${sessCtrl.item.uuid}">-->
<c:if test="${not empty sessCtrl.item.code}"><input type="hidden" name="code" value="${sessCtrl.item.code}"></c:if>

<input type="submit" name="_add" value="<fmt:message key="save"/> &gt;&gt;"/>
</form>
<p><fmt:message key="session.add.request"/></p>
<p><fmt:message key="comment.optional"/></p>

</ips:ctrl_div>

<ips:ctrl_div result="cancel">
<fmt:message key="cancelled"/>
</ips:ctrl_div>
</ips:ctrl_process>




</td></tr>
</table>
</body>
</html>
