package ipsk.db.speech.utils;

import java.util.List;

import ipsk.text.StringSequenceBuilder;

public class DuplicateItemcodesScriptImportException extends ImportException {

	private List<String> duplicateItemCodes;
	public List<String> getDuplicateItemCodes() {
		return duplicateItemCodes;
	}
	public DuplicateItemcodesScriptImportException(List<String> duplicateItemCodes) {
		super();
		this.duplicateItemCodes=duplicateItemCodes;
	}
	
	public String getMessage() {
		String dicsAsStr=StringSequenceBuilder.buildString(duplicateItemCodes, ',');
		return "Script has duplicate item codes: "+dicsAsStr;
	}
	
	
}
