package ipsk.webapps.audio;

import javax.sound.sampled.AudioSystem;

import ipsk.audio.arr.Selection;
import ipsk.db.speech.RecordingFile;

public class RecordingFileHelper {
	
	public static class RecordingFileEdit{
		private Long originalFrameLength=null; 
		private Double editSampleRate=null;
		private Long editStartFrame=null;
		private Long editEndFrame=null;
		
		public RecordingFileEdit(Double editSampleRate, Long editStartFrame, Long editEndFrame) {
			super();
			this.editSampleRate = editSampleRate;
			this.editStartFrame = editStartFrame;
			this.editEndFrame = editEndFrame;
		}
		
		public RecordingFileEdit(RecordingFile rf) {
			this(rf.getEditSampleRate(),rf.getEditStartFrame(),rf.getEditEndFrame());
			originalFrameLength=rf.getFrames();
		}
		
		public boolean isEdit() {
			return editStartFrame!=null || editEndFrame!=null;
		}
		
		public Long frameLength() {
			if(isEdit()) {
				long diff=editEndFrame-editStartFrame;
				if(diff>=0) {
					return diff;
				}else {
					return -diff;
				}
			}else {
				return originalFrameLength;
			}
		}

		public Long framePosForSampleRate(double sampleRate,Long framePos) {
			Long fpForSr=null;
			
			if(framePos!=null){
				// TODO transitional: Return original value if edit samplerate is not set until all editSampleRates are set in the database
				if(editSampleRate!=null && !editSampleRate.equals(sampleRate)) {
					fpForSr=Math.round(framePos*sampleRate/editSampleRate);
				}else {
					fpForSr=framePos;
				}
			}
			return fpForSr;
		}
		
		public Long editStartFrameForSampleRate(double sampleRate) {
			return framePosForSampleRate(sampleRate, editStartFrame);
		}
		
		public Long editEndFrameForSampleRate(double sampleRate) {
			return framePosForSampleRate(sampleRate, editEndFrame);
		}
		
		
		public Selection toSelection(double sampleRate) {
			Selection s=null;

			Long sf=editStartFrameForSampleRate(sampleRate);
			Long ef=editEndFrameForSampleRate(sampleRate);
			if(sf==null) {
				if(ef==null) {
					s=null;
				}else {
					// extract from original beginning to edit end frame	
					s=new Selection();
					s.setStart(0);
					s.setEnd(ef);
				}
			}else {
				if(ef==null) {
					// extract from edit start frame to end of original
					s=new Selection();
					s.setStart(sf);
					s.setEnd(AudioSystem.NOT_SPECIFIED);
				}else {
					// extract from edit start frame to edit end frame
					s=new Selection();
					s.setStart(sf);
					s.setEnd(ef);
				}
			}
			return s;
		}
		

	}

	
	
//	public static Selection selectionFromRecordingFileDescr(RecordingFileEdit rf,double sampleRate) {
//		Selection s=null;
//
//		Long sf=rf.editStartFrameForSampleRate(sampleRate);
//		Long ef=rf.editEndFrameForSampleRate(sampleRate);
//		if(sf==null) {
//			if(ef==null) {
//				s=null;
//			}else {
//				// extract from original beginning to edit end frame	
//				s=new Selection();
//				s.setStart(0);
//				s.setEnd(ef);
//			}
//		}else {
//			if(ef==null) {
//				// extract from edit start frame to end of original
//				s=new Selection();
//				s.setStart(sf);
//				s.setEnd(AudioSystem.NOT_SPECIFIED);
//			}else {
//				// extract from edit start frame to edit end frame
//				s=new Selection();
//				s.setStart(sf);
//				s.setEnd(ef);
//			}
//		}
//		return s;
//	}


}
