/*
 * Created on May 30, 2005
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package ipsk.webapps.db.servlets;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

import ips.servlet.http.FileServer;
import ipsk.audio.AudioPluginException;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.arr.Selection;
import ipsk.audio.plugins.ChannelSelectorPlugin;
import ipsk.audio.plugins.EditPlugin;
import ipsk.db.speech.RecordingFile;
import ipsk.net.http.Utils;
import ipsk.webapps.ControllerException;
import ipsk.webapps.PermissionDeniedException;
import ipsk.webapps.audio.RecordingFileHelper;
import ipsk.webapps.audio.RecordingFileHelper.RecordingFileEdit;
import ipsk.webapps.db.speech.RecordingFileController;

/**
 * @author klausj
 *
 * Decodes (if necessary) local audio files and sends them to clients. 
 */
public class AudioServlet extends FileServer{

	protected final boolean DEBUG=false;
	
	public final static String CONTENT_TYPE="audio/x-wav";
	
	private final static int DEF_BUF_SIZE=4096;
	
	//private SecurityManager securityManager;
	
	public void init() throws ServletException {
		super.init();
		
	}
	
	protected void doGet(
		HttpServletRequest req,
		HttpServletResponse res)
		throws IOException {
		log("Audio servlet...");
		if(DEBUG) log("Debug mode");
		int bufSize=DEF_BUF_SIZE;
		//ServletContext sc = getServletContext();
		//String reqURL = new String(req.getRequestURL());
		String recFileId =req.getParameter("recordingFileId");
		
		//String encoding=req.getParameter("encoding");
		String channelParam=req.getParameter("channel");
		
		RecordingFileController rfContr=new RecordingFileController();
		// do not open a transaction here
		rfContr.open();
		RecordingFile rf=null;
		RecordingFileEdit rfe=null;
		Selection sel=null;
		String rfStringDescr;
		String fileURLStr;
		boolean available=false;
		try {
			rf = rfContr.getById(req,Integer.parseInt(recFileId));
			available=(!rf.getStatus().equals(RecordingFile.Status.REGISTERED));
			rfStringDescr=rf.toString();
			fileURLStr=rf.getSignalFile();
			rfe=new RecordingFileEdit(rf.getEditSampleRate(), rf.getEditStartFrame(), rf.getEditEndFrame());
		} catch (NumberFormatException e2) {
			e2.printStackTrace();
			rfContr.close();
			String msg="Parameter recordingFileId: "+recFileId+" is not a number.";
			log("ERROR "+msg);
			res.sendError(500,msg);
			return;
		} catch (ControllerException e2) {
			e2.printStackTrace();
			rfContr.close();
			String msg;
			if(e2 instanceof PermissionDeniedException){
				msg="Permission denied for recordingFileId "+recFileId;
				log("ERROR "+msg);
				res.sendError(403,msg);
			}else{
				msg=e2.getMessage();
				log("ERROR "+msg);
				res.sendError(500,msg);
			}
			return;
		}finally{
			// we have all we need from recording file so close the controller
			rfContr.close();
		}
		log("Requested: " + rfStringDescr);
		
		if(!available){
			// not yet completely stored, return 404 not found
			String msg="Recording file "+recFileId+" has status REGISTERED";
			log("ERROR "+msg);
			res.sendError(404,msg);
			return;
		}
		
		URL fileURL=new URL(fileURLStr);
		AudioInputStream pcmStream=null;
		
		log("Create PCM stream for URL: " + fileURL);
		
		AudioInputStream srcStream=null;
		try {
			srcStream=ThreadSafeAudioSystem.getAudioInputStream(fileURL);
			AudioFormat af=srcStream.getFormat();
			if(DEBUG)log("Source audio format: "+af);
			sel=rfe.toSelection(af.getSampleRate());
			if(DEBUG)log("Using AudioSystemWrapper");
			pcmStream=ThreadSafeAudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED,srcStream);
		} catch(IOException ioe){
			log("ERROR IO exception audio file: "+rfStringDescr+": "+ioe.getMessage());
			ioe.printStackTrace();
			res.sendError(500,ioe.getMessage());
			return;
		} catch (UnsupportedAudioFileException uae) {	
			log("ERROR unsupported audio file: "+rfStringDescr);
			uae.printStackTrace();
			res.sendError(500,uae.getMessage());
			return;
		}
		
		// Filter selection from original stream
		AudioInputStream editSelStream=pcmStream;
		
		if(sel!=null) {
			EditPlugin editPlugin=new EditPlugin(sel);
			try {
				editSelStream=editPlugin.getAudioInputStream(pcmStream);
			} catch (AudioPluginException e) {
				if(editSelStream!=null)editSelStream.close();
                log("ERROR edit selection: "+rfStringDescr);
                e.printStackTrace();
                res.sendError(500,e.getMessage());
                return;
			}
		}
		
		AudioInputStream editStream=editSelStream;
		
		if (channelParam !=null){
			// Filter requested channel from edit selection stream
		    int channel=Integer.parseInt(channelParam);
		    ChannelSelectorPlugin chSel=new ChannelSelectorPlugin(channel);
		    try {
                editStream=chSel.getAudioInputStream(editSelStream);
            } catch (AudioPluginException e1) {
            	if(editStream!=null)editSelStream.close();
                log("ERROR channel select: "+rfStringDescr);
    		    //sendError(res,e1);
                e1.printStackTrace();
                res.sendError(500,e1.getMessage());
                return;
            }
		}
		
		// Stream original file throw edit plugins to temporary result audio wav file.
		File tmpFile=File.createTempFile(getClass().getName(),".wav");
		tmpFile.deleteOnExit();
		try{
			ThreadSafeAudioSystem.write(editStream,AudioFileFormat.Type.WAVE,tmpFile);
		}catch(IOException ioe){
			throw ioe;
		}finally{
			editStream.close();
		}
        
        long contentLength=tmpFile.length();
		
        res.setContentType(CONTENT_TYPE);
        //res.setContentLength((int)contentLength);
        Utils.responseSetContentLength(res, contentLength);
        
		serve(tmpFile,CONTENT_TYPE,req,res);
       
		log("Sent audio: " + rfStringDescr);
		
	}
	
}
