package ipsk.webapps.db.servlets;

import java.io.IOException;
import java.security.Principal;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import ips.security.jaas.InetOrgPersonPrincipal;

public class LoginCheckServlet extends HttpServlet {
	
	private String successForwardPath;
	private String failForwardPath;


		
		public void init() throws ServletException {
			ServletConfig config=getServletConfig();
			successForwardPath=config.getInitParameter("successForwardPath");
			failForwardPath=config.getInitParameter("failForwardPath");
		}
		
	@Override
	public void service(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {
		
		Principal principal=request.getUserPrincipal();
		String remoteUser=request.getRemoteUser();
		String authType=request.getAuthType();
		String username=request.getParameter("j_username");
		
		if(principal==null) {
			
			String password=request.getParameter("j_password");
			try{
				request.getSession(principal==null);
				request.login(username, password);
			}catch(ServletException se) {
				// How to distinguish different failures here??
				request.logout();
				HttpSession s=request.getSession();
				if(s!=null) {
					s.invalidate();
				}
				// Likely a wrong username/password
				RequestDispatcher rd = request.getRequestDispatcher(failForwardPath+"?login="+username+"&status=failed");
				rd.forward(request, response);
				return;

			}
			remoteUser=request.getRemoteUser();

			if(remoteUser!=null) {

				principal=request.getUserPrincipal();

				if(principal instanceof ips.security.jaas.InetOrgPersonPrincipal) {
					ips.security.jaas.InetOrgPersonPrincipal jaasPr=(InetOrgPersonPrincipal)principal;

				}

				RequestDispatcher rd = request.getRequestDispatcher(successForwardPath);
				rd.forward(request, response);
			}

		}else{
			// Already has a principal (is logged in)
			if(username==null || username.equalsIgnoreCase(remoteUser)) {
				// With username not set or same username: success
				RequestDispatcher rd = request.getRequestDispatcher(successForwardPath);
				rd.forward(request, response);
			}else {
				//With different username: Fail and explain
				RequestDispatcher rd = request.getRequestDispatcher(failForwardPath+"?login="+username+"&status=failed&failed_reason=already_logged_in");
				rd.forward(request, response);
			}
		}
		return;
	}
}
