package ipsk.webapps.db.servlets;

import ipsk.db.speech.Session;
import ipsk.util.zip.ZipPacker;
import ipsk.webapps.ControllerException;
import ipsk.webapps.db.speech.SessionController;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipInputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionExporter extends HttpServlet {

	protected void doGet(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException {
String user = req.getRemoteUser();
log("Session export servlet (GET) started for user " + user + "...");

sendZip(req, res);
}

protected void doPost(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException {
String user = req.getRemoteUser();
log("Session export servlet (POST) started for user " + user + "...");

sendZip(req, res);
}

private void sendZip(HttpServletRequest req, HttpServletResponse res)
	throws IOException {
		SessionController sessCtrl=new SessionController();
		Session s=null;
		String dirURLStr=null;
		sessCtrl.open();
		try {
			sessCtrl.processRequest(req);
			s=sessCtrl.getSession();

			if(s!=null){
				dirURLStr=s.getStorageDirectoryURL();
			}
		} catch (ControllerException e1) {
			
			e1.printStackTrace();
			throw new IOException("Could not get session!");
		}finally{
			sessCtrl.close();
		}
		if(dirURLStr!=null){
			try {
				URL dirURL=new URL(dirURLStr);
				if("file".equalsIgnoreCase(dirURL.getProtocol())){
					File dir=new File(dirURL.getFile());
					res.setContentType("application/zip");
					ZipPacker zipPacker = new ZipPacker(res.getOutputStream());
					zipPacker.packDirRecursive(dir);
					zipPacker.close();
					
				}
			} catch (MalformedURLException e) {
				e.printStackTrace();
				throw new IOException("Malformed URL directory path: "+dirURLStr);
			} 
		}
	}
}
