package ipsk.webapps.db.servlets;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ipsk.webapps.db.speech.BasicExportController;

@WebServlet(urlPatterns = "/handleStatus401")
public class UnauthorizedHandler extends HttpServlet {

	
	@Override
	protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		
		String reqCtxPath=req.getContextPath();
		
		Object errSrvNm=req.getAttribute(RequestDispatcher.ERROR_SERVLET_NAME);
		Object errReqUriObj=req.getAttribute(RequestDispatcher.ERROR_REQUEST_URI);
		
		
		ServletContext ctx=req.getServletContext();
		
		ctx.log("Req ctx path: "+reqCtxPath);
	
		ctx.log("Err req URI: "+errReqUriObj);

		String errPath=null;
		if(errReqUriObj instanceof String) {
			String errReqUri=(String)errReqUriObj;
			if(errReqUri.startsWith(reqCtxPath)) {
				errPath=errReqUri.substring(reqCtxPath.length());
			}
		}
		ctx.log("Err req path: "+errPath);
		
		
		
		if(errPath!=null) {

			if(! errPath.startsWith("/api")) {
				String encLoginUrl=resp.encodeRedirectURL(reqCtxPath+"/login.jsp");
				resp.reset();
				//resp.setHeader("WWW-Authenticate",null);
				resp.sendRedirect(encLoginUrl);
				
				return;
			}
		}
		
		String[] cmds=req.getParameterValues(BasicExportController.KEY_CMD);
		if(cmds!=null) {
			for(String cmd:cmds) {
				
				if(BasicExportController.CMD_UPDATE_VIEW_AJAX.equals(cmd)  && resp.getStatus()==401) {
					// Prevent authentication popup of the user agent (browser) for every AJAX view update call.
					// The popup will only appear if the HTTP status code is 401
					// (and the WWW-Authenticate: Basic header is present)
					// Return HTTP status 403 to prevent this.
					resp.setStatus(403);
					//req.getServletContext().log("Convert 401 to 403 response for AJAX call");
					return;
				}
			}
		}
//		resp.setStatus(403);
//		String ctxPath=req.getServletContext().getContextPath();
//		String encLoginUrl=resp.encodeRedirectURL(ctxPath+"/login.jsp");
//		resp.sendRedirect(encLoginUrl);

	}

}
