package ipsk.webapps.db.speech;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;

import ipsk.db.speech.DialectRegion;
import ipsk.db.speech.Project;
import ipsk.db.speech.UserRoleId;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.PermissionDeniedException;

public class DialectRegionController extends BasicPersistenceBeanController<DialectRegion> {
	
	public DialectRegionController() {
		super("WebSpeechDBPU",DialectRegion.class, "dialect_region");
		securityManager=new AdminSecurityManager();
	}
	public DialectRegionController(String persistenceUnit, String jsfIdentifier) {
		super(persistenceUnit, DialectRegion.class, jsfIdentifier);
		securityManager=new AdminSecurityManager();
	}
	

	public DialectRegion getById(int id){
		return (DialectRegion)super.getById(id);
	}
	
	
	@SuppressWarnings("unchecked")
	public List<DialectRegion> getOrderedDialectRegions(String projectName){
		List<DialectRegion> list=null;
		EntityManager em = getThreadEntityManager();
			Project selectedProject=em.find(Project.class, projectName);
			Query q = em.createQuery("SELECT dr FROM DialectRegion dr WHERE :selectedProject MEMBER OF dr.projects ORDER BY dr.position");
			q.setParameter("selectedProject", selectedProject);
			list=q.getResultList();
		return list;
	}

	
}
