package ipsk.webapps.db.speech;

import java.beans.IntrospectionException;

import ipsk.beans.ExtBeanInfo;
import ipsk.beans.ExtendedIntrospector;
import ipsk.db.speech.Speaker;


public class FormDefinitions {

	public static final String SPEAKER_FORM_CLASS_ID="java:"+Speaker.class.getName();
	
	public static String formTypeNameResourceKey(String propClassId) {

		if (SPEAKER_FORM_CLASS_ID.equals(propClassId)) {
			return "speaker.form";
		}

		return null;
	}
	
	public static String propertyResourceKey(Class<?> entityClass,String propName) {
		try {
			ExtBeanInfo ebi=ExtendedIntrospector.getExtendedBeanInfo(entityClass);
			return ebi.getPropertyResourceKey(propName);
		} catch (IntrospectionException e) {
			
		}
		
		return null;
	}

	
	
}
