package ipsk.webapps.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.validation.EMail;
import ipsk.util.EnumResourceKeys;
import ipsk.util.MemberResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

@ResourceBundleName("Messages")
@PreferredDisplayOrder("email,realisation,locale")
public class Invitation extends AbstractInvitation{

	@EnumResourceKeys(memberResourceKeys = {
			@MemberResourceKey(name = "SEND_MAIL", key = "invitation.realisation.send_mail"),
			@MemberResourceKey(name = "PROVIDE_LINK", key = "invitation.realisation.provide_link")
			}
	)
	public enum Realisation {SEND_MAIL,PROVIDE_LINK}
	
	private String email;
	private Realisation realisation=Realisation.SEND_MAIL;
	
	@ResourceKey("invitation.realisation")
	public Realisation getRealisation() {
		return realisation;
	}
	public void setRealisation(Realisation realisation) {
		this.realisation = realisation;
	}
	
	@EMail
	@ResourceKey("email")
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
}
