package ipsk.webapps.db.speech;

import java.util.Locale;

import ipsk.db.speech.LocalizedMessage;
import ipsk.webapps.BasicPersistenceBeanController;

public class LocalizedMessageController extends BasicPersistenceBeanController<LocalizedMessage> {
	
	public LocalizedMessageController() {
		super("WebSpeechDBPU",LocalizedMessage.class, "loc_message");
		securityManager=new AdminSecurityManager();
	}
	public LocalizedMessageController(String persistenceUnit, String jsfIdentifier) {
		super(persistenceUnit, LocalizedMessage.class, jsfIdentifier);
		securityManager=new AdminSecurityManager();
	}
	
	
	String[] getISOLanguageCodeList(){
		return Locale.getISOLanguages();
		
	}
	
}
