package ipsk.webapps.db.speech;

import java.util.UUID;

import javax.servlet.http.HttpServletRequest;

import ipsk.db.speech.Person;
import ipsk.db.speech.Project;
import ipsk.db.speech.UserRoleId;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.ControllerException;
import ipsk.webapps.PermissionDeniedException;

public class PersonController extends BasicPersistenceBeanController<Person> {
	
	public PersonController() {
		super("WebSpeechDBPU",Person.class, "person");
		securityManager=new AdminSecurityManager();
	}

	public Person getPerson() throws ControllerException {
		return (Person)getItem();
	}
	
	protected void setPropertiesOnNew(Object bean) {
		super.setPropertiesOnNew(bean);
		if(bean instanceof Person) {
			Person p=(Person)bean;
			p.setUuid(UUID.randomUUID().toString());
		}
	}
	

}
