package ipsk.webapps.db.speech.project;

import java.util.Locale;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ipsk.db.speech.Account;
import ipsk.db.speech.FormConfiguration;
import ipsk.db.speech.Project;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.UserRoleId;
import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.persistence.QueryParam;
import ipsk.webapps.ControllerException;
import ipsk.webapps.db.speech.BasicProjectAdminController;
import ipsk.webapps.db.speech.FormDefinitions;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;

public class FormConfigurationController extends BasicProjectAdminController<FormConfiguration> {
	

	
	public FormConfigurationController() {
		super("WebSpeechDBPU",FormConfiguration.class, "form_configuration");
	}
	public FormConfigurationController(String persistenceUnit, String jsfIdentifier) {
		super(persistenceUnit, FormConfiguration.class, jsfIdentifier);
	}
	
	public void speakerFormsOwnedByProject(HttpServletRequest req) throws ControllerException{
		Account acc = getAccountByRequest(req);
		
		createEmptyBeanTableModel(req);
		
		if (acc != null && req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())) {
			applyOwningProject(req);
			ParameterizedQuery<FormConfiguration> pq = new ParameterizedQuery<FormConfiguration>(queryType);

			String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
			String spkClassNm=Speaker.class.getName();
			pq.setWhereClause("("+jse+" IN (SELECT fm FROM FormConfiguration fm,Project pr WHERE :account MEMBER OF pr.adminAccounts AND "+ jse +".owningProject=pr AND fm.owningProject = :owningProject AND "+jse+".propertyClassId='java:"+spkClassNm+"'))");
			pq.setQueryParams(new QueryParam[] { new QueryParam("account",acc) , new QueryParam("owningProject", owningProject)});
			super.processRequest(req,pq);
		}
	}
	
	public String getDisplayNameSuggestion() {
		String sdn="";
		if(owningProject!=null) {
			int formCnt=owningProject.getOwnedForms().size();
			sdn="Speaker-Form-"+owningProject.getName()+"-"+(formCnt+1);
		}
		return sdn;
	}
	
	public String getSpeakerFormClassId() {
		return FormDefinitions.SPEAKER_FORM_CLASS_ID;
	}
	
	public String getFormTypeNameResourceKey() {
		FormConfiguration fc;
		try {
			fc = getItem();
			return formTypeNameResourceKey(fc);
		} catch (ControllerException e) {
			// return null
		}
		
		return null;
	}
	
	public String formTypeNameResourceKey(String propClassId) {
		return FormDefinitions.formTypeNameResourceKey(propClassId);
	}
	
	public String formTypeNameResourceKey(FormConfiguration fc) {
		
		if(fc!=null) {
			String propClassId=fc.getPropertyClassId();
			return FormDefinitions.formTypeNameResourceKey(propClassId);
		}
		return null;
	}
	

}
